/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class LayerNorm
extends DynamicCustomOp {
    private boolean noBias = false;

    public LayerNorm(SameDiff sameDiff, SDVariable input, SDVariable gain, SDVariable bias, int ... dimensions) {
        super(null, sameDiff, new SDVariable[]{input, gain, bias}, false);
        Preconditions.checkArgument((bias != null ? 1 : 0) != 0, (String)"LayerNorm: Use constructor without bias argument if bias is null / not available.");
        this.setDimensions(dimensions);
    }

    public LayerNorm(SameDiff sameDiff, SDVariable input, SDVariable gain, int ... dimensions) {
        super(null, sameDiff, new SDVariable[]{input, gain}, false);
        this.noBias = true;
        this.setDimensions(dimensions);
    }

    public LayerNorm(INDArray input, INDArray gain, INDArray bias, INDArray result, int ... dimensions) {
        super("layer_norm", new INDArray[]{input, gain, bias}, new INDArray[]{result});
        Preconditions.checkArgument((bias != null ? 1 : 0) != 0, (String)"LayerNorm: Use different constructor if bias is null.");
        this.setDimensions(dimensions);
    }

    public LayerNorm(INDArray input, INDArray gain, INDArray result, int ... dimensions) {
        super("layer_norm", new INDArray[]{input, gain}, new INDArray[]{result});
        this.noBias = true;
        this.setDimensions(dimensions);
    }

    @Override
    public void setDimensions(int[] dimensions) {
        Preconditions.checkArgument((dimensions != null ? 1 : 0) != 0, (String)"LayerNorm: You have to provide dimensions");
        Preconditions.checkArgument((dimensions.length > 0 ? 1 : 0) != 0, (String)"LayerNorm: You have to provide dimensions");
        this.dimensions = dimensions;
        this.addIArgument(dimensions);
    }

    @Override
    public String opName() {
        return "layer_norm";
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow name found for shape " + this.opName());
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx name found for shape " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradient) {
        SDVariable[] ret = this.noBias ? this.f().layerNormBp(this.arg(0), this.arg(1), gradient.get(0), this.dimensions) : this.f().layerNormBp(this.arg(0), this.arg(1), this.arg(2), gradient.get(0), this.dimensions);
        return Arrays.asList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() >= 2 && dataTypes.size() <= 3 ? 1 : 0) != 0, (String)"Expected exactly 2 or 3 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (DataType dataType : dataTypes) {
            Preconditions.checkState((boolean)dataType.isFPType(), (String)"Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            Preconditions.checkState((first == dataType ? 1 : 0) != 0, (String)"All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        return Collections.singletonList(first);
    }

    public LayerNorm() {
    }
}

