/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.regularization;

import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.Axpy;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.linalg.schedule.FixedSchedule;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class L2Regularization
implements Regularization {
    protected final ISchedule l2;

    public L2Regularization(double l2) {
        this(new FixedSchedule(l2));
    }

    public L2Regularization(@JsonProperty(value="l2") @NonNull ISchedule l2) {
        if (l2 == null) {
            throw new NullPointerException("l2 is marked @NonNull but is null");
        }
        this.l2 = l2;
    }

    @Override
    public Regularization.ApplyStep applyStep() {
        return Regularization.ApplyStep.BEFORE_UPDATER;
    }

    @Override
    public void apply(INDArray param, INDArray gradView, double lr, int iteration, int epoch) {
        double coeff = this.l2.valueAt(iteration, epoch);
        Nd4j.exec(new Axpy(param, gradView, gradView, coeff));
    }

    @Override
    public double score(INDArray param, int iteration, int epoch) {
        double norm2 = param.norm2Number().doubleValue();
        return this.l2.valueAt(iteration, epoch) * 0.5 * norm2 * norm2;
    }

    @Override
    public Regularization clone() {
        return new L2Regularization(this.l2.clone());
    }

    public ISchedule getL2() {
        return this.l2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof L2Regularization)) {
            return false;
        }
        L2Regularization other = (L2Regularization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ISchedule this$l2 = this.getL2();
        ISchedule other$l2 = other.getL2();
        return !(this$l2 == null ? other$l2 != null : !this$l2.equals(other$l2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof L2Regularization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ISchedule $l2 = this.getL2();
        result = result * 59 + ($l2 == null ? 43 : $l2.hashCode());
        return result;
    }

    public String toString() {
        return "L2Regularization(l2=" + this.getL2() + ")";
    }
}

