/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class LecunUniformInitScheme
extends BaseWeightInitScheme {
    private double fanIn;

    public LecunUniformInitScheme(char order, double fanIn) {
        super(order);
        this.fanIn = fanIn;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        double b = 3.0 / Math.sqrt(this.fanIn);
        return Nd4j.rand(shape, Nd4j.getDistributions().createUniform(-b, b));
    }

    @Override
    public WeightInit type() {
        return WeightInit.LECUN_UNIFORM;
    }

    public static LecunUniformInitSchemeBuilder builder() {
        return new LecunUniformInitSchemeBuilder();
    }

    public static class LecunUniformInitSchemeBuilder {
        private char order;
        private double fanIn;

        LecunUniformInitSchemeBuilder() {
        }

        public LecunUniformInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public LecunUniformInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public LecunUniformInitScheme build() {
            return new LecunUniformInitScheme(this.order, this.fanIn);
        }

        public String toString() {
            return "LecunUniformInitScheme.LecunUniformInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ")";
        }
    }
}

