/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.array;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.ArrayHolder;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SingleThreadArrayHolder
implements ArrayHolder {
    private final Map<String, INDArray> map = new HashMap<String, INDArray>();

    @Override
    public boolean hasArray(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        return this.map.containsKey(name);
    }

    @Override
    public INDArray getArray(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        return this.map.get(name);
    }

    @Override
    public void setArray(@NonNull String name, @NonNull INDArray array) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        this.map.put(name, array);
    }

    @Override
    public INDArray removeArray(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        return this.map.remove(name);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void initFrom(ArrayHolder arrayHolder) {
        this.map.clear();
        Collection<String> names = arrayHolder.arrayNames();
        for (String n : names) {
            this.map.put(n, arrayHolder.getArray(n));
        }
    }

    @Override
    public Collection<String> arrayNames() {
        return Collections.unmodifiableCollection(this.map.keySet());
    }

    @Override
    public void rename(String from, String to) {
        INDArray arr = this.map.remove(from);
        this.map.put(to, arr);
    }
}

