/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.imports.tensorflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class TFImportStatus {
    private final List<String> modelPaths;
    private final List<String> cantImportModelPaths;
    private final List<String> readErrorModelPaths;
    private final int totalNumOps;
    private final int numUniqueOps;
    private final Set<String> opNames;
    private final Set<String> importSupportedOpNames;
    private final Set<String> unsupportedOpNames;
    private final Map<String, Set<String>> unsupportedOpModels;

    public TFImportStatus merge(@NonNull TFImportStatus other) {
        if (other == null) {
            throw new NullPointerException("other is marked @NonNull but is null");
        }
        ArrayList<String> newModelPaths = new ArrayList<String>(this.modelPaths);
        newModelPaths.addAll(other.modelPaths);
        ArrayList<String> newCantImportModelPaths = new ArrayList<String>(this.cantImportModelPaths);
        newCantImportModelPaths.addAll(other.cantImportModelPaths);
        ArrayList<String> newReadErrorModelPaths = new ArrayList<String>(this.readErrorModelPaths);
        newReadErrorModelPaths.addAll(other.readErrorModelPaths);
        HashSet<String> newOpNames = new HashSet<String>(this.opNames);
        newOpNames.addAll(other.opNames);
        HashSet<String> newImportSupportedOpNames = new HashSet<String>(this.importSupportedOpNames);
        newImportSupportedOpNames.addAll(other.importSupportedOpNames);
        HashSet<String> newUnsupportedOpNames = new HashSet<String>(this.unsupportedOpNames);
        newUnsupportedOpNames.addAll(other.unsupportedOpNames);
        int countUnique = newImportSupportedOpNames.size() + newUnsupportedOpNames.size();
        HashMap<String, Set<String>> newUnsupportedOpModels = new HashMap<String, Set<String>>();
        if (this.unsupportedOpModels != null) {
            newUnsupportedOpModels.putAll(this.unsupportedOpModels);
        }
        if (other.unsupportedOpModels != null) {
            for (Map.Entry<String, Set<String>> e : other.unsupportedOpModels.entrySet()) {
                if (!newUnsupportedOpModels.containsKey(e.getKey())) {
                    newUnsupportedOpModels.put(e.getKey(), e.getValue());
                    continue;
                }
                ((Set)newUnsupportedOpModels.get(e.getKey())).addAll((Collection)e.getValue());
            }
        }
        return new TFImportStatus(newModelPaths, newCantImportModelPaths, newReadErrorModelPaths, this.totalNumOps + other.totalNumOps, countUnique, newOpNames, newImportSupportedOpNames, newUnsupportedOpNames, newUnsupportedOpModels);
    }

    public TFImportStatus(List<String> modelPaths, List<String> cantImportModelPaths, List<String> readErrorModelPaths, int totalNumOps, int numUniqueOps, Set<String> opNames, Set<String> importSupportedOpNames, Set<String> unsupportedOpNames, Map<String, Set<String>> unsupportedOpModels) {
        this.modelPaths = modelPaths;
        this.cantImportModelPaths = cantImportModelPaths;
        this.readErrorModelPaths = readErrorModelPaths;
        this.totalNumOps = totalNumOps;
        this.numUniqueOps = numUniqueOps;
        this.opNames = opNames;
        this.importSupportedOpNames = importSupportedOpNames;
        this.unsupportedOpNames = unsupportedOpNames;
        this.unsupportedOpModels = unsupportedOpModels;
    }

    public List<String> getModelPaths() {
        return this.modelPaths;
    }

    public List<String> getCantImportModelPaths() {
        return this.cantImportModelPaths;
    }

    public List<String> getReadErrorModelPaths() {
        return this.readErrorModelPaths;
    }

    public int getTotalNumOps() {
        return this.totalNumOps;
    }

    public int getNumUniqueOps() {
        return this.numUniqueOps;
    }

    public Set<String> getOpNames() {
        return this.opNames;
    }

    public Set<String> getImportSupportedOpNames() {
        return this.importSupportedOpNames;
    }

    public Set<String> getUnsupportedOpNames() {
        return this.unsupportedOpNames;
    }

    public Map<String, Set<String>> getUnsupportedOpModels() {
        return this.unsupportedOpModels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TFImportStatus)) {
            return false;
        }
        TFImportStatus other = (TFImportStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$modelPaths = this.getModelPaths();
        List<String> other$modelPaths = other.getModelPaths();
        if (this$modelPaths == null ? other$modelPaths != null : !((Object)this$modelPaths).equals(other$modelPaths)) {
            return false;
        }
        List<String> this$cantImportModelPaths = this.getCantImportModelPaths();
        List<String> other$cantImportModelPaths = other.getCantImportModelPaths();
        if (this$cantImportModelPaths == null ? other$cantImportModelPaths != null : !((Object)this$cantImportModelPaths).equals(other$cantImportModelPaths)) {
            return false;
        }
        List<String> this$readErrorModelPaths = this.getReadErrorModelPaths();
        List<String> other$readErrorModelPaths = other.getReadErrorModelPaths();
        if (this$readErrorModelPaths == null ? other$readErrorModelPaths != null : !((Object)this$readErrorModelPaths).equals(other$readErrorModelPaths)) {
            return false;
        }
        if (this.getTotalNumOps() != other.getTotalNumOps()) {
            return false;
        }
        if (this.getNumUniqueOps() != other.getNumUniqueOps()) {
            return false;
        }
        Set<String> this$opNames = this.getOpNames();
        Set<String> other$opNames = other.getOpNames();
        if (this$opNames == null ? other$opNames != null : !((Object)this$opNames).equals(other$opNames)) {
            return false;
        }
        Set<String> this$importSupportedOpNames = this.getImportSupportedOpNames();
        Set<String> other$importSupportedOpNames = other.getImportSupportedOpNames();
        if (this$importSupportedOpNames == null ? other$importSupportedOpNames != null : !((Object)this$importSupportedOpNames).equals(other$importSupportedOpNames)) {
            return false;
        }
        Set<String> this$unsupportedOpNames = this.getUnsupportedOpNames();
        Set<String> other$unsupportedOpNames = other.getUnsupportedOpNames();
        if (this$unsupportedOpNames == null ? other$unsupportedOpNames != null : !((Object)this$unsupportedOpNames).equals(other$unsupportedOpNames)) {
            return false;
        }
        Map<String, Set<String>> this$unsupportedOpModels = this.getUnsupportedOpModels();
        Map<String, Set<String>> other$unsupportedOpModels = other.getUnsupportedOpModels();
        return !(this$unsupportedOpModels == null ? other$unsupportedOpModels != null : !((Object)this$unsupportedOpModels).equals(other$unsupportedOpModels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TFImportStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $modelPaths = this.getModelPaths();
        result = result * 59 + ($modelPaths == null ? 43 : ((Object)$modelPaths).hashCode());
        List<String> $cantImportModelPaths = this.getCantImportModelPaths();
        result = result * 59 + ($cantImportModelPaths == null ? 43 : ((Object)$cantImportModelPaths).hashCode());
        List<String> $readErrorModelPaths = this.getReadErrorModelPaths();
        result = result * 59 + ($readErrorModelPaths == null ? 43 : ((Object)$readErrorModelPaths).hashCode());
        result = result * 59 + this.getTotalNumOps();
        result = result * 59 + this.getNumUniqueOps();
        Set<String> $opNames = this.getOpNames();
        result = result * 59 + ($opNames == null ? 43 : ((Object)$opNames).hashCode());
        Set<String> $importSupportedOpNames = this.getImportSupportedOpNames();
        result = result * 59 + ($importSupportedOpNames == null ? 43 : ((Object)$importSupportedOpNames).hashCode());
        Set<String> $unsupportedOpNames = this.getUnsupportedOpNames();
        result = result * 59 + ($unsupportedOpNames == null ? 43 : ((Object)$unsupportedOpNames).hashCode());
        Map<String, Set<String>> $unsupportedOpModels = this.getUnsupportedOpModels();
        result = result * 59 + ($unsupportedOpModels == null ? 43 : ((Object)$unsupportedOpModels).hashCode());
        return result;
    }

    public String toString() {
        return "TFImportStatus(modelPaths=" + this.getModelPaths() + ", cantImportModelPaths=" + this.getCantImportModelPaths() + ", readErrorModelPaths=" + this.getReadErrorModelPaths() + ", totalNumOps=" + this.getTotalNumOps() + ", numUniqueOps=" + this.getNumUniqueOps() + ", opNames=" + this.getOpNames() + ", importSupportedOpNames=" + this.getImportSupportedOpNames() + ", unsupportedOpNames=" + this.getUnsupportedOpNames() + ", unsupportedOpModels=" + this.getUnsupportedOpModels() + ")";
    }
}

