/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class Roll
extends DynamicCustomOp {
    public Roll() {
    }

    public Roll(@NonNull INDArray input, @NonNull INDArray axes, @NonNull INDArray shifts) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (axes == null) {
            throw new NullPointerException("axes is marked @NonNull but is null");
        }
        if (shifts == null) {
            throw new NullPointerException("shifts is marked @NonNull but is null");
        }
        Preconditions.checkArgument((axes.rank() == shifts.rank() ? 1 : 0) != 0, (String)"Roll: shifts and axes should be the same rank");
        Preconditions.checkArgument((axes.length() == shifts.length() ? 1 : 0) != 0, (String)"Roll: shifts and axes should be the same length");
        this.addInputArgument(input, axes, shifts);
    }

    public Roll(@NonNull INDArray input, int shift) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        this.addInputArgument(input);
        this.addIArgument(shift);
    }

    public Roll(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable shift) {
        super("", sameDiff, new SDVariable[]{input, shift});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked @NonNull but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (shift == null) {
            throw new NullPointerException("shift is marked @NonNull but is null");
        }
    }

    @Override
    public String opName() {
        return "roll";
    }

    @Override
    public String tensorflowName() {
        return "Roll";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

