/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Pooling2D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Pooling2D.class);
    protected Pooling2DConfig config;

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    public Pooling2D() {
    }

    public Pooling2D(SameDiff sameDiff, SDVariable[] inputs, Pooling2DConfig config) {
        super(null, sameDiff, inputs, false);
        this.config = config;
        this.addArgs();
    }

    public Pooling2D(@NonNull INDArray[] inputs, INDArray[] outputs, @NonNull Pooling2DConfig config) {
        super(inputs, outputs);
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        this.config = config;
        this.addArgs();
    }

    public Pooling2D(@NonNull INDArray input, INDArray output, @NonNull Pooling2DConfig config) {
        super(new INDArray[]{input}, Pooling2D.wrapOrNull(output));
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        this.config = config;
        this.addArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    private void addArgs() {
        Pooling2DType t = this.config.getType();
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isSameMode()));
        this.addIArgument(t == Pooling2DType.AVG ? this.config.getDivisor().ordinal() : (int)this.config.getExtra());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isNHWC()));
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String opName() {
        return this.getPoolingPrefix() + "pool2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Pooling2DDerivative pooling2DDerivative = Pooling2DDerivative.derivativeBuilder().inputs(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).config(this.config).build();
        ret.addAll(Arrays.asList(pooling2DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        Pooling2DConfig pooling2DConfig;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        Long sH = tfStrides.get(1);
        Long sW = tfStrides.get(2);
        AttrValue aKernels = nodeDef.getAttrOrThrow("ksize");
        List<Long> tfKernels = aKernels.getList().getIList();
        Long kH = tfKernels.get(1);
        Long kW = tfKernels.get(2);
        AttrValue aPadding = nodeDef.getAttrOrThrow("padding");
        List<Long> padding = aPadding.getList().getIList();
        String paddingMode = aPadding.getS().toStringUtf8().replaceAll("\"", "");
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        if (!isSameMode) {
            log.debug("Mode: {}", (Object)paddingMode);
        }
        this.config = pooling2DConfig = Pooling2DConfig.builder().sH(sH.intValue()).sW(sW.intValue()).type(null).isSameMode(isSameMode).kH(kH.intValue()).kW(kW.intValue()).pH(padding.get(0).intValue()).pW(padding.get(1).intValue()).build();
        this.addArgs();
        log.debug("Pooling: k: [{},{}]; s: [{}, {}], padding: {}", new Object[]{kH, kW, sH, sW, aPadding});
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        Pooling2DConfig pooling2DConfig;
        boolean isSameNode = attributesForNode.get("auto_pad").getS().equals((Object)"SAME");
        List<Long> kernelShape = attributesForNode.get("kernel_shape").getIntsList();
        List<Long> padding = attributesForNode.get("pads").getIntsList();
        List<Long> strides = attributesForNode.get("strides").getIntsList();
        this.config = pooling2DConfig = Pooling2DConfig.builder().sW(strides.get(0).intValue()).sH(strides.get(1).intValue()).type(null).isSameMode(isSameNode).kH(kernelShape.get(0).intValue()).kW(kernelShape.get(1).intValue()).pH(padding.get(0).intValue()).pW(padding.get(1).intValue()).build();
        this.addArgs();
    }

    public String getPoolingPrefix() {
        if (this.config == null) {
            return "somepooling";
        }
        switch (this.config.getType()) {
            case AVG: {
                return "avg";
            }
            case MAX: {
                return "max";
            }
            case PNORM: {
                return "pnorm";
            }
        }
        throw new IllegalStateException("No pooling type found.");
    }

    @Override
    public String onnxName() {
        return "Pooling";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 input data type for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Pooling2DBuilder sameDiffBuilder() {
        return new Pooling2DBuilder();
    }

    public Pooling2DConfig getConfig() {
        return this.config;
    }

    public static class Pooling2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private Pooling2DConfig config;

        Pooling2DBuilder() {
        }

        public Pooling2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Pooling2DBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Pooling2DBuilder config(Pooling2DConfig config) {
            this.config = config;
            return this;
        }

        public Pooling2D build() {
            return new Pooling2D(this.sameDiff, this.inputs, this.config);
        }

        public String toString() {
            return "Pooling2D.Pooling2DBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", config=" + this.config + ")";
        }
    }

    public static enum Divisor {
        EXCLUDE_PADDING,
        INCLUDE_PADDING;

    }

    public static enum Pooling2DType {
        MAX,
        AVG,
        PNORM;

    }
}

