/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.lang.reflect.Field;
import java.util.Map;
import org.nd4j.linalg.exception.ND4JIllegalStateException;

public abstract class BaseConvolutionConfig {
    public abstract Map<String, Object> toProperties();

    public Object getValue(Field property) {
        try {
            return property.get(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValueFor(Field target, Object value) {
        if (value == null) {
            throw new ND4JIllegalStateException("Unable to set field " + target + " using null value!");
        }
        value = this.ensureProperType(target, value);
        try {
            target.set(this, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private Object ensureProperType(Field targetType, Object value) {
        Class<?> valueType;
        Class<?> firstClass = targetType.getType();
        if (!firstClass.equals(valueType = value.getClass())) {
            if (firstClass.equals(int[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = number.intValue();
                }
                int otherValue = (Integer)value;
                int[] setValue = new int[]{otherValue};
                return setValue;
            }
            if (firstClass.equals(Integer[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = number.intValue();
                }
                Integer otherValue = (Integer)value;
                Integer[] setValue = new Integer[]{otherValue};
                return setValue;
            }
            if (firstClass.equals(long[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = number.longValue();
                }
                long otherValue = (Long)value;
                long[] setValue = new long[]{otherValue};
                return setValue;
            }
            if (firstClass.equals(Long[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = number.longValue();
                }
                Long otherValue = (Long)value;
                Long[] setValue = new Long[]{otherValue};
                return setValue;
            }
            if (firstClass.equals(double[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = number.doubleValue();
                }
                double otherValue = (Double)value;
                double[] setValue = new double[]{otherValue};
                return setValue;
            }
            if (firstClass.equals(Double[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = number.doubleValue();
                }
                Double otherValue = (Double)value;
                Double[] setValue = new Double[]{otherValue};
                return setValue;
            }
            if (firstClass.equals(float[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = Float.valueOf(number.floatValue());
                }
                float otherValue = ((Float)value).floatValue();
                float[] setValue = new float[]{otherValue};
                return setValue;
            }
            if (firstClass.equals(Float[].class)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    value = Float.valueOf(number.floatValue());
                }
                Float otherValue = (Float)value;
                Float[] setValue = new Float[]{otherValue};
                return setValue;
            }
        }
        return value;
    }

    protected abstract void validate();
}

