/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.weights;

import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.RNNWeights;

public class SRUWeights
extends RNNWeights {
    @NonNull
    private SDVariable weights;
    @NonNull
    private SDVariable bias;

    @Override
    public SDVariable[] args() {
        return new SDVariable[]{this.weights, this.bias};
    }

    SRUWeights(@NonNull SDVariable weights, @NonNull SDVariable bias) {
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (bias == null) {
            throw new NullPointerException("bias is marked @NonNull but is null");
        }
        this.weights = weights;
        this.bias = bias;
    }

    public static SRUWeightsBuilder builder() {
        return new SRUWeightsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SRUWeights)) {
            return false;
        }
        SRUWeights other = (SRUWeights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDVariable this$weights = this.getWeights();
        SDVariable other$weights = other.getWeights();
        if (this$weights == null ? other$weights != null : !((Object)this$weights).equals(other$weights)) {
            return false;
        }
        SDVariable this$bias = this.getBias();
        SDVariable other$bias = other.getBias();
        return !(this$bias == null ? other$bias != null : !((Object)this$bias).equals(other$bias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SRUWeights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SDVariable $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : ((Object)$weights).hashCode());
        SDVariable $bias = this.getBias();
        result = result * 59 + ($bias == null ? 43 : ((Object)$bias).hashCode());
        return result;
    }

    @NonNull
    public SDVariable getWeights() {
        return this.weights;
    }

    @NonNull
    public SDVariable getBias() {
        return this.bias;
    }

    public void setWeights(@NonNull SDVariable weights) {
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        this.weights = weights;
    }

    public void setBias(@NonNull SDVariable bias) {
        if (bias == null) {
            throw new NullPointerException("bias is marked @NonNull but is null");
        }
        this.bias = bias;
    }

    public String toString() {
        return "SRUWeights(weights=" + this.getWeights() + ", bias=" + this.getBias() + ")";
    }

    public static class SRUWeightsBuilder {
        private SDVariable weights;
        private SDVariable bias;

        SRUWeightsBuilder() {
        }

        public SRUWeightsBuilder weights(SDVariable weights) {
            this.weights = weights;
            return this;
        }

        public SRUWeightsBuilder bias(SDVariable bias) {
            this.bias = bias;
            return this;
        }

        public SRUWeights build() {
            return new SRUWeights(this.weights, this.bias);
        }

        public String toString() {
            return "SRUWeights.SRUWeightsBuilder(weights=" + this.weights + ", bias=" + this.bias + ")";
        }
    }
}

