/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class SequenceMask
extends DynamicCustomOp {
    public static final DataType DEFAULT_DTYPE = DataType.BOOL;
    private int maxLen;
    private boolean is_static_maxlen = false;
    private DataType dataType;

    public SequenceMask(SameDiff sameDiff, SDVariable input, SDVariable maxLen, DataType dataType) {
        super(null, sameDiff, new SDVariable[]{input, maxLen}, false);
        this.dataType = dataType;
    }

    public SequenceMask(SameDiff sameDiff, SDVariable input, int maxLen, DataType dataType) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        this.maxLen = maxLen;
        this.is_static_maxlen = true;
        this.addIArgument(maxLen);
        this.dataType = dataType;
    }

    public SequenceMask(SameDiff sameDiff, SDVariable input, DataType dataType) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        this.dataType = dataType;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        NodeDef targetNode = TFGraphMapper.getNodeWithNameFromGraph(graph, nodeDef.getInput(1));
        INDArray maxlen = TFGraphMapper.getNDArrayFromTensor(targetNode);
        if (maxlen == null) {
            this.is_static_maxlen = true;
        }
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        if (this.is_static_maxlen) {
            this.addIArgument(this.maxLen);
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> attrs = new LinkedHashMap<String, PropertyMapping>();
        if (this.is_static_maxlen) {
            PropertyMapping maxLen = PropertyMapping.builder().propertyNames(new String[]{"maxLen"}).tfAttrName("maxlen").build();
            attrs.put("maxLen", maxLen);
        }
        ret.put(this.tensorflowName(), attrs);
        return ret;
    }

    @Override
    public String opName() {
        return "sequence_mask";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return Collections.singletonList(this.f().zerosLike(this.arg()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        SDVariable[] args = this.args();
        Preconditions.checkState((dataTypes.size() == args.length ? 1 : 0) != 0, (String)"Expected list with exactly %s datatypes for %s, got %s", (Object)args.length, this.getClass(), dataTypes);
        return Collections.singletonList(this.dataType == null ? DEFAULT_DTYPE : this.dataType);
    }

    public SequenceMask() {
    }
}

