/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory.ops;

import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitsHammingDistance;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitwiseAnd;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitwiseOr;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitwiseXor;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CyclicRShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CyclicShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.RShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ShiftBits;
import org.nd4j.linalg.factory.NDValidation;
import org.nd4j.linalg.factory.Nd4j;

public class NDBitwise {
    public INDArray and(INDArray x, INDArray y) {
        NDValidation.validateInteger("and", "x", x);
        NDValidation.validateInteger("and", "y", y);
        Preconditions.checkArgument((boolean)NDValidation.isSameType(x, y), (String)"Must be same types");
        return Nd4j.exec(new BitwiseAnd(x, y))[0];
    }

    public INDArray bitRotl(INDArray x, INDArray shift) {
        NDValidation.validateInteger("bitRotl", "x", x);
        NDValidation.validateInteger("bitRotl", "shift", shift);
        return Nd4j.exec(new CyclicShiftBits(x, shift))[0];
    }

    public INDArray bitRotr(INDArray x, INDArray shift) {
        NDValidation.validateInteger("bitRotr", "x", x);
        NDValidation.validateInteger("bitRotr", "shift", shift);
        return Nd4j.exec(new CyclicRShiftBits(x, shift))[0];
    }

    public INDArray bitShift(INDArray x, INDArray shift) {
        NDValidation.validateInteger("bitShift", "x", x);
        NDValidation.validateInteger("bitShift", "shift", shift);
        return Nd4j.exec(new ShiftBits(x, shift))[0];
    }

    public INDArray bitShiftRight(INDArray x, INDArray shift) {
        NDValidation.validateInteger("bitShiftRight", "x", x);
        NDValidation.validateInteger("bitShiftRight", "shift", shift);
        return Nd4j.exec(new RShiftBits(x, shift))[0];
    }

    public INDArray bitsHammingDistance(INDArray x, INDArray y) {
        NDValidation.validateInteger("bitsHammingDistance", "x", x);
        NDValidation.validateInteger("bitsHammingDistance", "y", y);
        Preconditions.checkArgument((boolean)NDValidation.isSameType(x, y), (String)"Must be same types");
        return Nd4j.exec(new BitsHammingDistance(x, y))[0];
    }

    public INDArray leftShift(INDArray x, INDArray y) {
        NDValidation.validateInteger("leftShift", "x", x);
        NDValidation.validateInteger("leftShift", "y", y);
        return Nd4j.exec(new ShiftBits(x, y))[0];
    }

    public INDArray leftShiftCyclic(INDArray x, INDArray y) {
        NDValidation.validateInteger("leftShiftCyclic", "x", x);
        NDValidation.validateInteger("leftShiftCyclic", "y", y);
        return Nd4j.exec(new CyclicShiftBits(x, y))[0];
    }

    public INDArray or(INDArray x, INDArray y) {
        NDValidation.validateInteger("or", "x", x);
        NDValidation.validateInteger("or", "y", y);
        Preconditions.checkArgument((boolean)NDValidation.isSameType(x, y), (String)"Must be same types");
        return Nd4j.exec(new BitwiseOr(x, y))[0];
    }

    public INDArray rightShift(INDArray x, INDArray y) {
        NDValidation.validateInteger("rightShift", "x", x);
        NDValidation.validateInteger("rightShift", "y", y);
        return Nd4j.exec(new RShiftBits(x, y))[0];
    }

    public INDArray rightShiftCyclic(INDArray x, INDArray y) {
        NDValidation.validateInteger("rightShiftCyclic", "x", x);
        NDValidation.validateInteger("rightShiftCyclic", "y", y);
        return Nd4j.exec(new CyclicRShiftBits(x, y))[0];
    }

    public INDArray xor(INDArray x, INDArray y) {
        NDValidation.validateInteger("xor", "x", x);
        NDValidation.validateInteger("xor", "y", y);
        Preconditions.checkArgument((boolean)NDValidation.isSameType(x, y), (String)"Must be same types");
        return Nd4j.exec(new BitwiseXor(x, y))[0];
    }
}

