/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory.ops;

import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.custom.RandomExponential;
import org.nd4j.linalg.api.ops.random.impl.BernoulliDistribution;
import org.nd4j.linalg.api.ops.random.impl.BinomialDistribution;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.ops.random.impl.LogNormalDistribution;
import org.nd4j.linalg.api.ops.random.impl.TruncatedNormalDistribution;
import org.nd4j.linalg.api.ops.random.impl.UniformDistribution;
import org.nd4j.linalg.factory.Nd4j;

public class NDRandom {
    public INDArray bernoulli(double p, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return Nd4j.exec(new BernoulliDistribution(p, datatype, shape));
    }

    public INDArray binomial(int nTrials, double p, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return Nd4j.exec(new BinomialDistribution(nTrials, p, datatype, shape));
    }

    public INDArray[] exponential(double lambda, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        Preconditions.checkArgument((lambda > 0.0 ? 1 : 0) != 0, (String)"Must be positive");
        return Nd4j.exec(new RandomExponential(lambda, datatype, shape));
    }

    public INDArray logNormal(double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return Nd4j.exec(new LogNormalDistribution(mean, stddev, datatype, shape));
    }

    public INDArray normal(double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return Nd4j.exec(new GaussianDistribution(mean, stddev, datatype, shape));
    }

    public INDArray normalTruncated(double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return Nd4j.exec(new TruncatedNormalDistribution(mean, stddev, datatype, shape));
    }

    public INDArray uniform(double min, double max, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return Nd4j.exec(new UniformDistribution(min, max, datatype, shape));
    }
}

