/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.functions;

import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.function.Function;

public class StableNumber
implements Function<Number, Number> {
    private Type type;

    public StableNumber(Type type) {
        this.type = type;
    }

    public Number apply(Number number) {
        switch (this.type) {
            case DOUBLE: {
                if (Double.isInfinite(number.doubleValue())) {
                    return -1.7976931348623157E308;
                }
                if (Double.isNaN(number.doubleValue())) {
                    return Nd4j.EPS_THRESHOLD;
                }
            }
            case FLOAT: {
                if (Float.isInfinite(number.floatValue())) {
                    return Float.valueOf(-3.4028235E38f);
                }
                if (!Float.isNaN(number.floatValue())) break;
                return Nd4j.EPS_THRESHOLD;
            }
        }
        throw new IllegalStateException("Illegal opType");
    }

    public static enum Type {
        DOUBLE,
        FLOAT;

    }
}

