/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.inverse;

import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.checkutil.CheckUtil;

public class InvertMatrix {
    public static INDArray invert(INDArray arr, boolean inPlace) {
        if (arr.rank() == 2 && arr.length() == 1L) {
            if (inPlace) {
                return arr.rdivi(1.0);
            }
            return arr.rdiv(1.0);
        }
        if (!arr.isSquare()) {
            throw new IllegalArgumentException("invalid array: must be square matrix");
        }
        RealMatrix rm = CheckUtil.convertToApacheMatrix(arr);
        RealMatrix rmInverse = new LUDecomposition(rm).getSolver().getInverse();
        INDArray inverse = CheckUtil.convertFromApacheMatrix(rmInverse, arr.dataType());
        if (inPlace) {
            arr.assign(inverse);
        }
        return inverse;
    }

    public static INDArray pinvert(INDArray arr, boolean inPlace) {
        RealMatrix realMatrix = CheckUtil.convertToApacheMatrix(arr);
        QRDecomposition decomposition = new QRDecomposition(realMatrix, 0.0);
        DecompositionSolver solver = decomposition.getSolver();
        if (!solver.isNonSingular()) {
            throw new IllegalArgumentException("invalid array: must be singular matrix");
        }
        RealMatrix pinvRM = solver.getInverse();
        INDArray pseudoInverse = CheckUtil.convertFromApacheMatrix(pinvRM, arr.dataType());
        if (inPlace) {
            arr.assign(pseudoInverse);
        }
        return pseudoInverse;
    }

    public static INDArray pLeftInvert(INDArray arr, boolean inPlace) {
        try {
            INDArray inv = InvertMatrix.invert(arr.transpose().mmul(arr), inPlace).mmul(arr.transpose());
            if (inPlace) {
                arr.assign(inv);
            }
            return inv;
        }
        catch (SingularMatrixException e) {
            throw new IllegalArgumentException("Full column rank condition for left pseudo inverse was not met.");
        }
    }

    public static INDArray pRightInvert(INDArray arr, boolean inPlace) {
        try {
            INDArray inv = arr.transpose().mmul(InvertMatrix.invert(arr.mmul(arr.transpose()), inPlace));
            if (inPlace) {
                arr.assign(inv);
            }
            return inv;
        }
        catch (SingularMatrixException e) {
            throw new IllegalArgumentException("Full row rank condition for right pseudo inverse was not met.");
        }
    }
}

