/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.Nadam;
import org.nd4j.linalg.ops.transforms.Transforms;

public class NadamUpdater
implements GradientUpdater<Nadam> {
    public static final String M_STATE = "M";
    public static final String V_STATE = "V";
    private Nadam config;
    private INDArray m;
    private INDArray v;
    private char gradientReshapeOrder;

    public NadamUpdater(Nadam config) {
        this.config = config;
    }

    @Override
    public void setState(@NonNull Map<String, INDArray> stateMap, boolean initialize) {
        if (stateMap == null) {
            throw new NullPointerException("stateMap is marked @NonNull but is null");
        }
        if (!stateMap.containsKey(M_STATE) || !stateMap.containsKey(V_STATE) || stateMap.size() != 2) {
            throw new IllegalStateException("State map should contain only keys [M,V] but has keys " + stateMap.keySet());
        }
        this.m = stateMap.get(M_STATE);
        this.v = stateMap.get(V_STATE);
    }

    @Override
    public Map<String, INDArray> getState() {
        HashMap<String, INDArray> r = new HashMap<String, INDArray>();
        r.put(M_STATE, this.m);
        r.put(V_STATE, this.v);
        return r;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, long[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVector()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(0);
        }
        long length = viewArray.length();
        this.m = viewArray.get(NDArrayIndex.point(0L), NDArrayIndex.interval(0L, length / 2L));
        this.v = viewArray.get(NDArrayIndex.point(0L), NDArrayIndex.interval(length / 2L, length));
        this.m = Shape.newShapeNoCopy(this.m, gradientShape, gradientOrder == 'f');
        this.v = Shape.newShapeNoCopy(this.v, gradientShape, gradientOrder == 'f');
        if (this.m == null || this.v == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view arrays");
        }
        this.gradientReshapeOrder = gradientOrder;
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration, int epoch) {
        if (this.m == null || this.v == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        double beta1 = this.config.getBeta1();
        double beta2 = this.config.getBeta2();
        double learningRate = this.config.getLearningRate(iteration, epoch);
        double epsilon = this.config.getEpsilon();
        INDArray oneMinusBeta1Grad = gradient.mul(1.0 - beta1);
        this.m.muli(beta1).addi(oneMinusBeta1Grad);
        INDArray oneMinusBeta2GradSquared = gradient.mul(gradient).muli(1.0 - beta2);
        this.v.muli(beta2).addi(oneMinusBeta2GradSquared);
        double beta1t = FastMath.pow((double)beta1, (int)(iteration + 1));
        INDArray biasCorrectedEstimateOfMomentum = this.m.mul(beta1).divi(1.0 - beta1t);
        INDArray secondTerm = oneMinusBeta1Grad.divi(1.0 - beta1t);
        INDArray alphat = biasCorrectedEstimateOfMomentum.add(secondTerm).muli(learningRate);
        INDArray sqrtV = Transforms.sqrt(this.v.dup(this.gradientReshapeOrder), false).addi(epsilon);
        gradient.assign(alphat).divi(sqrtV);
    }

    @Override
    public Nadam getConfig() {
        return this.config;
    }

    public INDArray getM() {
        return this.m;
    }

    public INDArray getV() {
        return this.v;
    }

    public char getGradientReshapeOrder() {
        return this.gradientReshapeOrder;
    }

    public void setConfig(Nadam config) {
        this.config = config;
    }

    public void setM(INDArray m) {
        this.m = m;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public void setGradientReshapeOrder(char gradientReshapeOrder) {
        this.gradientReshapeOrder = gradientReshapeOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NadamUpdater)) {
            return false;
        }
        NadamUpdater other = (NadamUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Nadam this$config = this.getConfig();
        Nadam other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$m = this.getM();
        INDArray other$m = other.getM();
        if (this$m == null ? other$m != null : !this$m.equals(other$m)) {
            return false;
        }
        INDArray this$v = this.getV();
        INDArray other$v = other.getV();
        if (this$v == null ? other$v != null : !this$v.equals(other$v)) {
            return false;
        }
        return this.getGradientReshapeOrder() == other.getGradientReshapeOrder();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NadamUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Nadam $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $m = this.getM();
        result = result * 59 + ($m == null ? 43 : $m.hashCode());
        INDArray $v = this.getV();
        result = result * 59 + ($v == null ? 43 : $v.hashCode());
        result = result * 59 + this.getGradientReshapeOrder();
        return result;
    }

    public String toString() {
        return "NadamUpdater(config=" + this.getConfig() + ", m=" + this.getM() + ", v=" + this.getV() + ", gradientReshapeOrder=" + this.getGradientReshapeOrder() + ")";
    }
}

