/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.graph.FlatGraph;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.validation.Nd4jCommonValidator;
import org.nd4j.validation.ValidationResult;

public class Nd4jValidator {
    private Nd4jValidator() {
    }

    public static ValidationResult validateINDArrayFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        return Nd4jValidator.validateINDArrayFile(f, null);
    }

    public static ValidationResult validateINDArrayFile(@NonNull File f, DataType ... allowableDataTypes) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile((File)f, (String)"INDArray File", (boolean)false);
        if (vr != null && !vr.isValid()) {
            vr.setFormatClass(INDArray.class);
            return vr;
        }
        try (INDArray arr = Nd4j.readBinary(f);){
            if (allowableDataTypes != null) {
                ArrayUtils.contains((Object[])allowableDataTypes, (Object)arr.dataType());
            }
        }
        catch (IOException e) {
            return ValidationResult.builder().valid(false).formatType("INDArray File").formatClass(INDArray.class).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Unable to read file (IOException)")).exception((Throwable)e).build();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError || t.getMessage().toLowerCase().contains("failed to allocate")) {
                return ValidationResult.builder().valid(true).formatType("INDArray File").formatClass(INDArray.class).path(Nd4jCommonValidator.getPath((File)f)).build();
            }
            return ValidationResult.builder().valid(false).formatType("INDArray File").formatClass(INDArray.class).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("File may be corrupt or is not a binary INDArray file")).exception(t).build();
        }
        return ValidationResult.builder().valid(true).formatType("INDArray File").formatClass(INDArray.class).path(Nd4jCommonValidator.getPath((File)f)).build();
    }

    public static ValidationResult validateINDArrayTextFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile((File)f, (String)"INDArray Text File", (boolean)false);
        if (vr != null && !vr.isValid()) {
            vr.setFormatClass(INDArray.class);
            return vr;
        }
        try (INDArray arr = Nd4j.readTxt(f.getPath());){
            System.out.println();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError || t.getMessage().toLowerCase().contains("failed to allocate")) {
                return ValidationResult.builder().valid(true).formatType("INDArray Text File").formatClass(INDArray.class).path(Nd4jCommonValidator.getPath((File)f)).build();
            }
            return ValidationResult.builder().valid(false).formatType("INDArray Text File").formatClass(INDArray.class).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("File may be corrupt or is not a text INDArray file")).exception(t).build();
        }
        return ValidationResult.builder().valid(true).formatType("INDArray Text File").formatClass(INDArray.class).path(Nd4jCommonValidator.getPath((File)f)).build();
    }

    public static ValidationResult validateNpyFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile((File)f, (String)"Numpy .npy File", (boolean)false);
        if (vr != null && !vr.isValid()) {
            return vr;
        }
        try {
            INDArray arr = Nd4j.createFromNpyFile(f);
            Throwable throwable = null;
            if (arr != null) {
                if (throwable != null) {
                    try {
                        arr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    arr.close();
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError || t.getMessage().toLowerCase().contains("failed to allocate")) {
                return ValidationResult.builder().valid(true).formatType("Numpy .npy File").path(Nd4jCommonValidator.getPath((File)f)).build();
            }
            return ValidationResult.builder().valid(false).formatType("Numpy .npy File").path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("File may be corrupt or is not a Numpy .npy file")).exception(t).build();
        }
        return ValidationResult.builder().valid(true).formatType("Numpy .npy File").path(Nd4jCommonValidator.getPath((File)f)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationResult validateNpzFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile((File)f, (String)"Numpy .npz File", (boolean)false);
        if (vr != null && !vr.isValid()) {
            return vr;
        }
        Map<String, INDArray> m = null;
        try {
            m = Nd4j.createFromNpzFile(f);
        }
        catch (Throwable t) {
            ValidationResult validationResult = ValidationResult.builder().valid(false).formatType("Numpy .npz File").path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("File may be corrupt or is not a Numpy .npz file")).exception(t).build();
            return validationResult;
        }
        finally {
            if (m != null) {
                for (INDArray arr : m.values()) {
                    if (arr == null) continue;
                    arr.close();
                }
            }
        }
        return ValidationResult.builder().valid(true).formatType("Numpy .npz File").path(Nd4jCommonValidator.getPath((File)f)).build();
    }

    public static ValidationResult validateNumpyTxtFile(@NonNull File f, @NonNull String delimiter, @NonNull Charset charset) {
        String s;
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked @NonNull but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked @NonNull but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile((File)f, (String)"Numpy text file", (boolean)false);
        if (vr != null && !vr.isValid()) {
            return vr;
        }
        try {
            s = FileUtils.readFileToString((File)f, (Charset)charset);
        }
        catch (Throwable t) {
            return ValidationResult.builder().valid(false).formatType("Numpy text file").path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("File may be corrupt or is not a Numpy text file")).exception(t).build();
        }
        String[] lines = s.split("\n");
        int countPerLine = 0;
        for (int i = 0; i < lines.length; ++i) {
            String[] lineSplit = lines[i].split(delimiter);
            if (i == 0) {
                countPerLine = lineSplit.length;
            } else if (!lines[i].isEmpty() && countPerLine != lineSplit.length) {
                return ValidationResult.builder().valid(false).formatType("Numpy text file").path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Number of values in each line is not the same for all lines: File may be corrupt, is not a Numpy text file, or delimiter \"" + delimiter + "\" is incorrect")).build();
            }
            for (int j = 0; j < lineSplit.length; ++j) {
                try {
                    Double.parseDouble(lineSplit[j]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return ValidationResult.builder().valid(false).formatType("Numpy text file").path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("File may be corrupt, is not a Numpy text file, or delimiter \"" + delimiter + "\" is incorrect")).exception((Throwable)e).build();
                }
            }
        }
        return ValidationResult.builder().valid(true).formatType("Numpy text file").path(Nd4jCommonValidator.getPath((File)f)).build();
    }

    public static ValidationResult validateSameDiffFlatBuffers(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile((File)f, (String)"SameDiff FlatBuffers file", (boolean)false);
        if (vr != null && !vr.isValid()) {
            return vr;
        }
        try {
            byte[] bytes;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
                bytes = IOUtils.toByteArray((InputStream)is);
            }
            ByteBuffer bbIn = ByteBuffer.wrap(bytes);
            FlatGraph fg = FlatGraph.getRootAsFlatGraph(bbIn);
            int vl = fg.variablesLength();
            int ol = fg.nodesLength();
            System.out.println();
        }
        catch (Throwable t) {
            return ValidationResult.builder().valid(false).formatType("SameDiff FlatBuffers file").formatClass(SameDiff.class).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("File may be corrupt or is not a SameDiff file in FlatBuffers format")).exception(t).build();
        }
        return ValidationResult.builder().valid(true).formatType("SameDiff FlatBuffers file").formatClass(SameDiff.class).path(Nd4jCommonValidator.getPath((File)f)).build();
    }
}

