/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.workspace;

import java.util.Arrays;
import org.nd4j.linalg.api.memory.MemoryWorkspace;

public class WorkspacesCloseable
implements AutoCloseable {
    private MemoryWorkspace[] workspaces;

    public WorkspacesCloseable(MemoryWorkspace ... workspaces) {
        if (workspaces == null) {
            throw new NullPointerException("workspaces is marked @NonNull but is null");
        }
        this.workspaces = workspaces;
    }

    @Override
    public void close() {
        for (int i = this.workspaces.length - 1; i >= 0; --i) {
            this.workspaces[i].close();
        }
    }

    public MemoryWorkspace[] getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(MemoryWorkspace[] workspaces) {
        this.workspaces = workspaces;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkspacesCloseable)) {
            return false;
        }
        WorkspacesCloseable other = (WorkspacesCloseable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getWorkspaces(), other.getWorkspaces());
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkspacesCloseable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getWorkspaces());
        return result;
    }

    public String toString() {
        return "WorkspacesCloseable(workspaces=" + Arrays.deepToString(this.getWorkspaces()) + ")";
    }
}

