/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

package org.nd4j.linalg.api.ops.impl.transforms.strict;

import lombok.NoArgsConstructor;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformStrictOp;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SigmoidDerivative;

import java.util.Collections;
import java.util.List;

/**
 * LogSigmoid function
 *
 * @author raver119@gmail.com
 */
@NoArgsConstructor
public class LogSigmoid extends BaseTransformStrictOp {
    public LogSigmoid(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        super(sameDiff, i_v, inPlace);
    }

    public LogSigmoid(SameDiff sameDiff, SDVariable i_v) {
        this(sameDiff, i_v, false);
    }

    public LogSigmoid(INDArray x, INDArray z) {
        super(x, z);
    }

    public LogSigmoid(INDArray ndArray) {
        super(ndArray);
    }

    @Override
    public int opNum() {
        return 49;
    }

    @Override
    public String opName() {
        return "logsigmoid";
    }

    @Override
    public String onnxName() {
        return "LogSigmoid";
    }

    @Override
    public String tensorflowName() {
        return "LogSigmoid";
    }


    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable v = new SigmoidDerivative(sameDiff, arg(), i_v.get(0)).outputVariable().div(sameDiff.nn.sigmoid(arg()));
        return Collections.singletonList(v);
    }


}
