/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitsHammingDistance;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitwiseAnd;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitwiseOr;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BitwiseXor;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CyclicRShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CyclicShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.RShiftBits;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ShiftBits;

public class SDBitwise
extends SDOps {
    public SDBitwise(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable and(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("and", "x", x);
        SDValidation.validateInteger("and", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        return new BitwiseAnd(this.sd, x, y).outputVariable();
    }

    public SDVariable and(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("and", "x", x);
        SDValidation.validateInteger("and", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        SDVariable out = new BitwiseAnd(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable bitRotl(SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitRotl", "x", x);
        SDValidation.validateInteger("bitRotl", "shift", shift);
        return new CyclicShiftBits(this.sd, x, shift).outputVariable();
    }

    public SDVariable bitRotl(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitRotl", "x", x);
        SDValidation.validateInteger("bitRotl", "shift", shift);
        SDVariable out = new CyclicShiftBits(this.sd, x, shift).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable bitRotr(SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitRotr", "x", x);
        SDValidation.validateInteger("bitRotr", "shift", shift);
        return new CyclicRShiftBits(this.sd, x, shift).outputVariable();
    }

    public SDVariable bitRotr(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitRotr", "x", x);
        SDValidation.validateInteger("bitRotr", "shift", shift);
        SDVariable out = new CyclicRShiftBits(this.sd, x, shift).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable bitShift(SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitShift", "x", x);
        SDValidation.validateInteger("bitShift", "shift", shift);
        return new ShiftBits(this.sd, x, shift).outputVariable();
    }

    public SDVariable bitShift(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitShift", "x", x);
        SDValidation.validateInteger("bitShift", "shift", shift);
        SDVariable out = new ShiftBits(this.sd, x, shift).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable bitShiftRight(SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitShiftRight", "x", x);
        SDValidation.validateInteger("bitShiftRight", "shift", shift);
        return new RShiftBits(this.sd, x, shift).outputVariable();
    }

    public SDVariable bitShiftRight(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("bitShiftRight", "x", x);
        SDValidation.validateInteger("bitShiftRight", "shift", shift);
        SDVariable out = new RShiftBits(this.sd, x, shift).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable bitsHammingDistance(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitsHammingDistance", "x", x);
        SDValidation.validateInteger("bitsHammingDistance", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        return new BitsHammingDistance(this.sd, x, y).outputVariable();
    }

    public SDVariable bitsHammingDistance(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitsHammingDistance", "x", x);
        SDValidation.validateInteger("bitsHammingDistance", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        SDVariable out = new BitsHammingDistance(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable leftShift(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("leftShift", "x", x);
        SDValidation.validateInteger("leftShift", "y", y);
        return new ShiftBits(this.sd, x, y).outputVariable();
    }

    public SDVariable leftShift(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("leftShift", "x", x);
        SDValidation.validateInteger("leftShift", "y", y);
        SDVariable out = new ShiftBits(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable leftShiftCyclic(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("leftShiftCyclic", "x", x);
        SDValidation.validateInteger("leftShiftCyclic", "y", y);
        return new CyclicShiftBits(this.sd, x, y).outputVariable();
    }

    public SDVariable leftShiftCyclic(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("leftShiftCyclic", "x", x);
        SDValidation.validateInteger("leftShiftCyclic", "y", y);
        SDVariable out = new CyclicShiftBits(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable or(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("or", "x", x);
        SDValidation.validateInteger("or", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        return new BitwiseOr(this.sd, x, y).outputVariable();
    }

    public SDVariable or(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("or", "x", x);
        SDValidation.validateInteger("or", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        SDVariable out = new BitwiseOr(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable rightShift(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("rightShift", "x", x);
        SDValidation.validateInteger("rightShift", "y", y);
        return new RShiftBits(this.sd, x, y).outputVariable();
    }

    public SDVariable rightShift(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("rightShift", "x", x);
        SDValidation.validateInteger("rightShift", "y", y);
        SDVariable out = new RShiftBits(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable rightShiftCyclic(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("rightShiftCyclic", "x", x);
        SDValidation.validateInteger("rightShiftCyclic", "y", y);
        return new CyclicRShiftBits(this.sd, x, y).outputVariable();
    }

    public SDVariable rightShiftCyclic(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("rightShiftCyclic", "x", x);
        SDValidation.validateInteger("rightShiftCyclic", "y", y);
        SDVariable out = new CyclicRShiftBits(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable xor(SDVariable x, SDVariable y) {
        SDValidation.validateInteger("xor", "x", x);
        SDValidation.validateInteger("xor", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        return new BitwiseXor(this.sd, x, y).outputVariable();
    }

    public SDVariable xor(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("xor", "x", x);
        SDValidation.validateInteger("xor", "y", y);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(x, y), (String)"Must be same types");
        SDVariable out = new BitwiseXor(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

