/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.IntArrayIntIndexAdpater;
import org.nd4j.imports.descriptors.properties.adapters.NDArrayShapeAdapter;
import org.nd4j.imports.descriptors.properties.adapters.StringNotEqualsAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Conv3D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Conv3D.class);
    protected Conv3DConfig config;
    private static final String INVALID_CONFIGURATION = "Invalid Conv3D configuration : sW = %s pH = %s dW = %s ";

    public Conv3D() {
    }

    public Conv3D(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv3DConfig config) {
        this(sameDiff, Conv3D.wrapFilterNull(input, weights, bias), config);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public Conv3D(SameDiff sameDiff, SDVariable[] inputFunctions, Conv3DConfig config) {
        super(sameDiff, inputFunctions);
        this.initConfig(config);
    }

    public Conv3D(INDArray[] inputs, INDArray[] outputs, Conv3DConfig config) {
        super(inputs, outputs);
        this.initConfig(config);
    }

    public Conv3D(@NonNull INDArray input, @NonNull INDArray weights, INDArray bias, INDArray output, @NonNull Conv3DConfig config) {
        this(Conv3D.wrapFilterNull(input, weights, bias), Conv3D.wrapOrNull(output), config);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public Conv3D(INDArray input, INDArray weights, INDArray bias, Conv3DConfig config) {
        this(Conv3D.wrapFilterNull(input, weights, bias), null, config);
    }

    public Conv3D(INDArray input, INDArray weights, Conv3DConfig config) {
        this(Conv3D.wrapFilterNull(input, weights), null, config);
    }

    private void initConfig(Conv3DConfig config) {
        this.config = config;
        Preconditions.checkState((config.getSW() >= 1L && config.getPH() >= 0L && config.getDW() >= 1L ? 1 : 0) != 0, (String)INVALID_CONFIGURATION, (long)config.getSW(), (long)config.getPH(), (long)config.getDW());
        this.addArgs();
    }

    private void addArgs() {
        this.addIArgument(this.getConfig().getKD(), this.getConfig().getKH(), this.getConfig().getKW(), this.getConfig().getSD(), this.getConfig().getSH(), this.getConfig().getSW(), this.getConfig().getPD(), this.getConfig().getPH(), this.getConfig().getPW(), this.getConfig().getDD(), this.getConfig().getDH(), this.getConfig().getDW(), this.getConfig().isSameMode() ? 1L : 0L, this.getConfig().isNCDHW() ? 0L : 1L);
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = Conv3DConfig.builder().kD((Long)this.iArguments.get(0)).kH((Long)this.iArguments.get(1)).kW((Long)this.iArguments.get(2)).sD((Long)this.iArguments.get(3)).sH((Long)this.iArguments.get(4)).sW((Long)this.iArguments.get(5)).pD((Long)this.iArguments.get(6)).pH((Long)this.iArguments.get(7)).pW((Long)this.iArguments.get(8)).dD((Long)this.iArguments.get(9)).dH((Long)this.iArguments.get(10)).dW((Long)this.iArguments.get(11)).isSameMode((Long)this.iArguments.get(12) == 1L).dataFormat((Long)this.iArguments.get(13) == 1L ? "NCDHW" : "NDHWC").build();
        }
        return this.config.getValue(property);
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        LinkedHashMap<String, Map<String, AttributeAdapter>> ret = new LinkedHashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, AttributeAdapter> tfAdapters = new LinkedHashMap<String, AttributeAdapter>();
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(this);
        tfAdapters.put("kD", new NDArrayShapeAdapter(0));
        tfAdapters.put("kH", new NDArrayShapeAdapter(1));
        tfAdapters.put("kW", new NDArrayShapeAdapter(2));
        tfAdapters.put("sD", new IntArrayIntIndexAdpater(1));
        tfAdapters.put("sH", new IntArrayIntIndexAdpater(2));
        tfAdapters.put("sW", new IntArrayIntIndexAdpater(3));
        tfAdapters.put("pD", new IntArrayIntIndexAdpater(1));
        tfAdapters.put("pH", new IntArrayIntIndexAdpater(2));
        tfAdapters.put("pW", new IntArrayIntIndexAdpater(3));
        tfAdapters.put("isSameMode", new StringNotEqualsAdapter("VALID"));
        ret.put(this.tensorflowName(), tfAdapters);
        return ret;
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null) {
            return Collections.emptyMap();
        }
        return this.config.toProperties();
    }

    @Override
    public String opName() {
        return "conv3dnew";
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kD", "kW", "kH"}).tfInputPosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"sD", "sW", "sH"}).build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dD", "dH", "dW"}).tfAttrName("rates").build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping paddingWidthHeight = PropertyMapping.builder().onnxAttrName("padding").propertyNames(new String[]{"pD", "pW", "pH"}).build();
        PropertyMapping dataFormat = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        PropertyMapping outputPadding = PropertyMapping.builder().propertyNames(new String[]{"aD", "aH", "aW"}).build();
        PropertyMapping biasUsed = PropertyMapping.builder().propertyNames(new String[]{"biasUsed"}).build();
        for (PropertyMapping propertyMapping : new PropertyMapping[]{kernelMapping, strideMapping, dilationMapping, sameMode, paddingWidthHeight, dataFormat, outputPadding, biasUsed}) {
            for (String keys : propertyMapping.getPropertyNames()) {
                map.put(keys, propertyMapping);
            }
        }
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Conv3DDerivative conv3DDerivative = Conv3DDerivative.derivativeBuilder().conv3DConfig(this.config).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).build();
        ret.addAll(Arrays.asList(conv3DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No ONNX op name found for: " + this.getClass().getName());
    }

    @Override
    public String tensorflowName() {
        return "Conv3D";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Conv3DBuilder sameDiffBuilder() {
        return new Conv3DBuilder();
    }

    public Conv3DConfig getConfig() {
        return this.config;
    }

    public static class Conv3DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private Conv3DConfig config;

        Conv3DBuilder() {
        }

        public Conv3DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Conv3DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Conv3DBuilder config(Conv3DConfig config) {
            this.config = config;
            return this;
        }

        public Conv3D build() {
            return new Conv3D(this.sameDiff, this.inputFunctions, this.config);
        }

        public String toString() {
            return "Conv3D.Conv3DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", config=" + this.config + ")";
        }
    }
}

