/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.outputs;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMDataFormat;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMLayerConfig;

public class LSTMLayerOutputs {
    private LSTMDataFormat dataFormat;
    private SDVariable timeSeriesOutput;
    private SDVariable lastCellStateOutput;
    private SDVariable lastTimeStepOutput;

    public LSTMLayerOutputs(SDVariable[] outputs, LSTMLayerConfig lstmLayerConfig) {
        Preconditions.checkArgument((outputs.length > 0 && outputs.length <= 3 ? 1 : 0) != 0, (String)"Must have from 1 to 3 LSTM layer outputs, got %s", (int)outputs.length);
        int i = 0;
        this.timeSeriesOutput = lstmLayerConfig.isRetFullSequence() ? outputs[i++] : null;
        this.lastTimeStepOutput = lstmLayerConfig.isRetLastH() ? outputs[i++] : null;
        this.lastCellStateOutput = lstmLayerConfig.isRetLastC() ? outputs[i++] : null;
        this.dataFormat = lstmLayerConfig.getLstmdataformat();
    }

    public SDVariable getOutput() {
        Preconditions.checkArgument((this.timeSeriesOutput != null ? 1 : 0) != 0, (String)"retFullSequence was setted as false in LSTMLayerConfig");
        return this.timeSeriesOutput;
    }

    public SDVariable getLastState() {
        Preconditions.checkArgument((this.lastCellStateOutput != null ? 1 : 0) != 0, (String)"retLastC was setted as false in LSTMLayerConfig");
        return this.lastCellStateOutput;
    }

    public SDVariable getLastOutput() {
        Preconditions.checkArgument((this.lastTimeStepOutput != null ? 1 : 0) != 0, (String)"retLastH was setted as false in LSTMLayerConfig");
        return this.lastTimeStepOutput;
    }

    public LSTMDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public SDVariable getTimeSeriesOutput() {
        return this.timeSeriesOutput;
    }

    public SDVariable getLastCellStateOutput() {
        return this.lastCellStateOutput;
    }

    public SDVariable getLastTimeStepOutput() {
        return this.lastTimeStepOutput;
    }
}

