/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;
import org.tensorflow.framework.TensorShapeProto;

public class Reshape
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Reshape.class);
    private long[] shape;

    public Reshape(SameDiff sameDiff, SDVariable i_v, long[] shape) {
        super(null, sameDiff, new SDVariable[]{i_v});
        this.shape = shape;
        this.addIArgument(shape);
    }

    public Reshape(SameDiff sameDiff, SDVariable i_v, SDVariable shape) {
        super(null, sameDiff, new SDVariable[]{i_v, shape});
    }

    public Reshape(INDArray in, long ... shape) {
        super(new INDArray[]{in}, null);
        this.shape = shape;
        this.addIArgument(shape);
    }

    public Reshape(@NonNull INDArray in, @NonNull INDArray shape, INDArray out) {
        super(null, new INDArray[]{in, shape}, Reshape.wrapOrNull(out), null, (List<Integer>)null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
    }

    public Reshape(INDArray in, INDArray shape) {
        this(in, shape, null);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (!nodeDef.containsAttr("TShape") && nodeDef.getInputCount() == 1) {
            this.shape = new long[0];
            return;
        }
        if (nodeDef.getInputCount() == 1) {
            AttrValue shape = nodeDef.getAttrOrThrow("Tshape");
            if (!shape.hasShape()) {
                long[] shapeRet = new long[]{1L, shape.getValueCase().getNumber()};
                this.shape = shapeRet;
            } else {
                List<TensorShapeProto.Dim> shapeVals = shape.getShape().getDimList();
                if (shapeVals.size() > 1) {
                    this.shape = new long[shapeVals.size()];
                    for (int i = 0; i < shapeVals.size(); ++i) {
                        this.shape[i] = (int)shapeVals.get(i).getSize();
                    }
                } else {
                    this.shape = new long[2];
                    this.shape[0] = 1L;
                    this.shape[1] = (int)shapeVals.get(0).getSize();
                }
            }
            if (this.shape != null) {
                this.addIArgument(this.shape);
            }
        }
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping shapeMapping = PropertyMapping.builder().onnxAttrName("shape").tfInputPosition(-1).propertyNames(new String[]{"shape"}).build();
        map.put("shape", shapeMapping);
        ret.put(this.tensorflowName(), map);
        ret.put(this.onnxName(), map);
        return ret;
    }

    @Override
    public String opName() {
        return "reshape";
    }

    @Override
    public String onnxName() {
        return "Reshape";
    }

    @Override
    public String tensorflowName() {
        return "Reshape";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable origShape = this.sameDiff.shape(this.arg());
        SDVariable ret = this.sameDiff.reshape(i_v.get(0), origShape);
        return Collections.singletonList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Collections.singletonList(dataTypes.get(0));
    }

    public Reshape() {
    }
}

