/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;

public class Min
extends BaseDynamicTransformOp {
    public Min() {
    }

    public Min(SameDiff sameDiff, @NonNull SDVariable first, @NonNull SDVariable second) {
        this(sameDiff, new SDVariable[]{first, second}, false);
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
    }

    public Min(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(sameDiff, args, inPlace);
    }

    public Min(INDArray first, INDArray second, INDArray out) {
        INDArray[] iNDArrayArray;
        INDArray[] iNDArrayArray2 = new INDArray[]{first, second};
        if (out == null) {
            iNDArrayArray = null;
        } else {
            INDArray[] iNDArrayArray3 = new INDArray[1];
            iNDArrayArray = iNDArrayArray3;
            iNDArrayArray3[0] = out;
        }
        super(iNDArrayArray2, iNDArrayArray);
    }

    public Min(INDArray first, INDArray second) {
        this(first, second, null);
    }

    public Min(INDArray[] inputs, INDArray[] outputs) {
        super(inputs, outputs);
    }

    @Override
    public String opName() {
        return "minimum";
    }

    @Override
    public String onnxName() {
        return "Min";
    }

    @Override
    public String tensorflowName() {
        return "Minimum";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable min = this.outputVariables()[0];
        SDVariable eq1 = this.sameDiff.eq(this.larg(), min).castTo(this.arg(0).dataType());
        SDVariable eq2 = this.sameDiff.eq(this.rarg(), min).castTo(this.arg(1).dataType());
        return Arrays.asList(eq1.mul(f1.get(0)), eq2.mul(f1.get(0)));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState((dataTypes.get(0) == dataTypes.get(1) ? 1 : 0) != 0, (String)"Input datatypes must be the same, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

