/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.factory.Nd4j;

public class BinomialDistribution
extends BaseRandomOp {
    private int trials;
    private double probability;

    public BinomialDistribution(SameDiff sd, int trials, double probability, long[] shape) {
        super(sd, shape);
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistribution(SameDiff sd, int trials, double probability, DataType dataType, long[] shape) {
        this(sd, trials, probability, shape);
        this.dataType = dataType;
    }

    public BinomialDistribution(int trials, double probability, DataType dt, long[] shape) {
        this(Nd4j.createUninitialized(dt, shape), trials, probability);
    }

    public BinomialDistribution() {
    }

    public BinomialDistribution(@NonNull INDArray z, int trials, double probability) {
        super(z, z, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistribution(@NonNull INDArray z, int trials, @NonNull INDArray probabilities) {
        super(z, probabilities, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked non-null but is null");
        }
        if ((long)trials > probabilities.length()) {
            throw new IllegalStateException("Number of trials is > then amount of probabilities provided");
        }
        if (probabilities.elementWiseStride() < 1) {
            throw new IllegalStateException("Probabilities array shouldn't have negative elementWiseStride");
        }
        Preconditions.checkArgument((probabilities.dataType() == z.dataType() ? 1 : 0) != 0, (String)"Probabilities and Z operand should have same data type");
        this.trials = trials;
        this.probability = 0.0;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistribution(@NonNull INDArray z, @NonNull INDArray probabilities) {
        this(z, (int)probabilities.length(), probabilities);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked non-null but is null");
        }
    }

    @Override
    public int opNum() {
        return 8;
    }

    @Override
    public String opName() {
        return "distribution_binomial";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }

    @Override
    public void setZ(INDArray z) {
        this.x = z;
        this.y = z;
        this.z = z;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes == null || inputDataTypes.isEmpty() ? 1 : 0) != 0, (String)"Expected no input datatypes (no args) for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(DataType.DOUBLE);
    }

    @Override
    public boolean isTripleArgRngOp() {
        return true;
    }
}

