/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.serde.json;

import org.nd4j.common.primitives.AtomicBoolean;
import org.nd4j.common.primitives.AtomicDouble;
import org.nd4j.common.primitives.serde.JsonDeserializerAtomicBoolean;
import org.nd4j.common.primitives.serde.JsonDeserializerAtomicDouble;
import org.nd4j.common.primitives.serde.JsonSerializerAtomicBoolean;
import org.nd4j.common.primitives.serde.JsonSerializerAtomicDouble;
import org.nd4j.shade.jackson.annotation.JsonAutoDetect;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.Module;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.module.SimpleModule;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMappers {
    private static final Logger log = LoggerFactory.getLogger(JsonMappers.class);
    private static ObjectMapper jsonMapper = JsonMappers.configureMapper(new ObjectMapper());
    private static ObjectMapper yamlMapper = JsonMappers.configureMapper(new ObjectMapper((JsonFactory)new YAMLFactory()));

    public static ObjectMapper getMapper() {
        return jsonMapper;
    }

    public static ObjectMapper getYamlMapper() {
        return jsonMapper;
    }

    private static ObjectMapper configureMapper(ObjectMapper ret) {
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, false);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule atomicModule = new SimpleModule();
        atomicModule.addSerializer(AtomicDouble.class, (JsonSerializer)new JsonSerializerAtomicDouble());
        atomicModule.addSerializer(AtomicBoolean.class, (JsonSerializer)new JsonSerializerAtomicBoolean());
        atomicModule.addDeserializer(AtomicDouble.class, (JsonDeserializer)new JsonDeserializerAtomicDouble());
        atomicModule.addDeserializer(AtomicBoolean.class, (JsonDeserializer)new JsonDeserializerAtomicBoolean());
        ret.registerModule((Module)atomicModule);
        ret.setVisibilityChecker(ret.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.ANY));
        return ret;
    }
}

