/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.memory.conf;

import java.io.Serializable;
import org.nd4j.linalg.api.memory.enums.AllocationPolicy;
import org.nd4j.linalg.api.memory.enums.LearningPolicy;
import org.nd4j.linalg.api.memory.enums.LocationPolicy;
import org.nd4j.linalg.api.memory.enums.MirroringPolicy;
import org.nd4j.linalg.api.memory.enums.ResetPolicy;
import org.nd4j.linalg.api.memory.enums.SpillPolicy;

public class WorkspaceConfiguration
implements Serializable {
    protected AllocationPolicy policyAllocation;
    protected SpillPolicy policySpill;
    protected MirroringPolicy policyMirroring;
    protected LearningPolicy policyLearning;
    protected ResetPolicy policyReset;
    protected LocationPolicy policyLocation;
    protected String tempFilePath;
    protected long initialSize;
    protected long minSize;
    protected long maxSize;
    protected int cyclesBeforeInitialization;
    protected double overallocationLimit;
    protected int stepsNumber;

    private static AllocationPolicy $default$policyAllocation() {
        return AllocationPolicy.OVERALLOCATE;
    }

    private static SpillPolicy $default$policySpill() {
        return SpillPolicy.EXTERNAL;
    }

    private static MirroringPolicy $default$policyMirroring() {
        return MirroringPolicy.FULL;
    }

    private static LearningPolicy $default$policyLearning() {
        return LearningPolicy.FIRST_LOOP;
    }

    private static ResetPolicy $default$policyReset() {
        return ResetPolicy.BLOCK_LEFT;
    }

    private static LocationPolicy $default$policyLocation() {
        return LocationPolicy.RAM;
    }

    private static String $default$tempFilePath() {
        return null;
    }

    private static long $default$initialSize() {
        return 0L;
    }

    private static long $default$minSize() {
        return 0L;
    }

    private static long $default$maxSize() {
        return 0L;
    }

    private static int $default$cyclesBeforeInitialization() {
        return 0;
    }

    private static double $default$overallocationLimit() {
        return 0.3;
    }

    private static int $default$stepsNumber() {
        return 2;
    }

    public static WorkspaceConfigurationBuilder builder() {
        return new WorkspaceConfigurationBuilder();
    }

    public AllocationPolicy getPolicyAllocation() {
        return this.policyAllocation;
    }

    public SpillPolicy getPolicySpill() {
        return this.policySpill;
    }

    public MirroringPolicy getPolicyMirroring() {
        return this.policyMirroring;
    }

    public LearningPolicy getPolicyLearning() {
        return this.policyLearning;
    }

    public ResetPolicy getPolicyReset() {
        return this.policyReset;
    }

    public LocationPolicy getPolicyLocation() {
        return this.policyLocation;
    }

    public String getTempFilePath() {
        return this.tempFilePath;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getCyclesBeforeInitialization() {
        return this.cyclesBeforeInitialization;
    }

    public double getOverallocationLimit() {
        return this.overallocationLimit;
    }

    public int getStepsNumber() {
        return this.stepsNumber;
    }

    public void setPolicyAllocation(AllocationPolicy policyAllocation) {
        this.policyAllocation = policyAllocation;
    }

    public void setPolicySpill(SpillPolicy policySpill) {
        this.policySpill = policySpill;
    }

    public void setPolicyMirroring(MirroringPolicy policyMirroring) {
        this.policyMirroring = policyMirroring;
    }

    public void setPolicyLearning(LearningPolicy policyLearning) {
        this.policyLearning = policyLearning;
    }

    public void setPolicyReset(ResetPolicy policyReset) {
        this.policyReset = policyReset;
    }

    public void setPolicyLocation(LocationPolicy policyLocation) {
        this.policyLocation = policyLocation;
    }

    public void setTempFilePath(String tempFilePath) {
        this.tempFilePath = tempFilePath;
    }

    public void setInitialSize(long initialSize) {
        this.initialSize = initialSize;
    }

    public void setMinSize(long minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void setCyclesBeforeInitialization(int cyclesBeforeInitialization) {
        this.cyclesBeforeInitialization = cyclesBeforeInitialization;
    }

    public void setOverallocationLimit(double overallocationLimit) {
        this.overallocationLimit = overallocationLimit;
    }

    public void setStepsNumber(int stepsNumber) {
        this.stepsNumber = stepsNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkspaceConfiguration)) {
            return false;
        }
        WorkspaceConfiguration other = (WorkspaceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AllocationPolicy this$policyAllocation = this.getPolicyAllocation();
        AllocationPolicy other$policyAllocation = other.getPolicyAllocation();
        if (this$policyAllocation == null ? other$policyAllocation != null : !((Object)((Object)this$policyAllocation)).equals((Object)other$policyAllocation)) {
            return false;
        }
        SpillPolicy this$policySpill = this.getPolicySpill();
        SpillPolicy other$policySpill = other.getPolicySpill();
        if (this$policySpill == null ? other$policySpill != null : !((Object)((Object)this$policySpill)).equals((Object)other$policySpill)) {
            return false;
        }
        MirroringPolicy this$policyMirroring = this.getPolicyMirroring();
        MirroringPolicy other$policyMirroring = other.getPolicyMirroring();
        if (this$policyMirroring == null ? other$policyMirroring != null : !((Object)((Object)this$policyMirroring)).equals((Object)other$policyMirroring)) {
            return false;
        }
        LearningPolicy this$policyLearning = this.getPolicyLearning();
        LearningPolicy other$policyLearning = other.getPolicyLearning();
        if (this$policyLearning == null ? other$policyLearning != null : !((Object)((Object)this$policyLearning)).equals((Object)other$policyLearning)) {
            return false;
        }
        ResetPolicy this$policyReset = this.getPolicyReset();
        ResetPolicy other$policyReset = other.getPolicyReset();
        if (this$policyReset == null ? other$policyReset != null : !((Object)((Object)this$policyReset)).equals((Object)other$policyReset)) {
            return false;
        }
        LocationPolicy this$policyLocation = this.getPolicyLocation();
        LocationPolicy other$policyLocation = other.getPolicyLocation();
        if (this$policyLocation == null ? other$policyLocation != null : !((Object)((Object)this$policyLocation)).equals((Object)other$policyLocation)) {
            return false;
        }
        String this$tempFilePath = this.getTempFilePath();
        String other$tempFilePath = other.getTempFilePath();
        if (this$tempFilePath == null ? other$tempFilePath != null : !this$tempFilePath.equals(other$tempFilePath)) {
            return false;
        }
        if (this.getInitialSize() != other.getInitialSize()) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getCyclesBeforeInitialization() != other.getCyclesBeforeInitialization()) {
            return false;
        }
        if (Double.compare(this.getOverallocationLimit(), other.getOverallocationLimit()) != 0) {
            return false;
        }
        return this.getStepsNumber() == other.getStepsNumber();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkspaceConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AllocationPolicy $policyAllocation = this.getPolicyAllocation();
        result = result * 59 + ($policyAllocation == null ? 43 : ((Object)((Object)$policyAllocation)).hashCode());
        SpillPolicy $policySpill = this.getPolicySpill();
        result = result * 59 + ($policySpill == null ? 43 : ((Object)((Object)$policySpill)).hashCode());
        MirroringPolicy $policyMirroring = this.getPolicyMirroring();
        result = result * 59 + ($policyMirroring == null ? 43 : ((Object)((Object)$policyMirroring)).hashCode());
        LearningPolicy $policyLearning = this.getPolicyLearning();
        result = result * 59 + ($policyLearning == null ? 43 : ((Object)((Object)$policyLearning)).hashCode());
        ResetPolicy $policyReset = this.getPolicyReset();
        result = result * 59 + ($policyReset == null ? 43 : ((Object)((Object)$policyReset)).hashCode());
        LocationPolicy $policyLocation = this.getPolicyLocation();
        result = result * 59 + ($policyLocation == null ? 43 : ((Object)((Object)$policyLocation)).hashCode());
        String $tempFilePath = this.getTempFilePath();
        result = result * 59 + ($tempFilePath == null ? 43 : $tempFilePath.hashCode());
        long $initialSize = this.getInitialSize();
        result = result * 59 + (int)($initialSize >>> 32 ^ $initialSize);
        long $minSize = this.getMinSize();
        result = result * 59 + (int)($minSize >>> 32 ^ $minSize);
        long $maxSize = this.getMaxSize();
        result = result * 59 + (int)($maxSize >>> 32 ^ $maxSize);
        result = result * 59 + this.getCyclesBeforeInitialization();
        long $overallocationLimit = Double.doubleToLongBits(this.getOverallocationLimit());
        result = result * 59 + (int)($overallocationLimit >>> 32 ^ $overallocationLimit);
        result = result * 59 + this.getStepsNumber();
        return result;
    }

    public String toString() {
        return "WorkspaceConfiguration(policyAllocation=" + (Object)((Object)this.getPolicyAllocation()) + ", policySpill=" + (Object)((Object)this.getPolicySpill()) + ", policyMirroring=" + (Object)((Object)this.getPolicyMirroring()) + ", policyLearning=" + (Object)((Object)this.getPolicyLearning()) + ", policyReset=" + (Object)((Object)this.getPolicyReset()) + ", policyLocation=" + (Object)((Object)this.getPolicyLocation()) + ", tempFilePath=" + this.getTempFilePath() + ", initialSize=" + this.getInitialSize() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", cyclesBeforeInitialization=" + this.getCyclesBeforeInitialization() + ", overallocationLimit=" + this.getOverallocationLimit() + ", stepsNumber=" + this.getStepsNumber() + ")";
    }

    public WorkspaceConfiguration() {
        this.policyAllocation = WorkspaceConfiguration.$default$policyAllocation();
        this.policySpill = WorkspaceConfiguration.$default$policySpill();
        this.policyMirroring = WorkspaceConfiguration.$default$policyMirroring();
        this.policyLearning = WorkspaceConfiguration.$default$policyLearning();
        this.policyReset = WorkspaceConfiguration.$default$policyReset();
        this.policyLocation = WorkspaceConfiguration.$default$policyLocation();
        this.tempFilePath = WorkspaceConfiguration.$default$tempFilePath();
        this.initialSize = WorkspaceConfiguration.$default$initialSize();
        this.minSize = WorkspaceConfiguration.$default$minSize();
        this.maxSize = WorkspaceConfiguration.$default$maxSize();
        this.cyclesBeforeInitialization = WorkspaceConfiguration.$default$cyclesBeforeInitialization();
        this.overallocationLimit = WorkspaceConfiguration.$default$overallocationLimit();
        this.stepsNumber = WorkspaceConfiguration.$default$stepsNumber();
    }

    public WorkspaceConfiguration(AllocationPolicy policyAllocation, SpillPolicy policySpill, MirroringPolicy policyMirroring, LearningPolicy policyLearning, ResetPolicy policyReset, LocationPolicy policyLocation, String tempFilePath, long initialSize, long minSize, long maxSize, int cyclesBeforeInitialization, double overallocationLimit, int stepsNumber) {
        this.policyAllocation = policyAllocation;
        this.policySpill = policySpill;
        this.policyMirroring = policyMirroring;
        this.policyLearning = policyLearning;
        this.policyReset = policyReset;
        this.policyLocation = policyLocation;
        this.tempFilePath = tempFilePath;
        this.initialSize = initialSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.cyclesBeforeInitialization = cyclesBeforeInitialization;
        this.overallocationLimit = overallocationLimit;
        this.stepsNumber = stepsNumber;
    }

    public static class WorkspaceConfigurationBuilder {
        private boolean policyAllocation$set;
        private AllocationPolicy policyAllocation;
        private boolean policySpill$set;
        private SpillPolicy policySpill;
        private boolean policyMirroring$set;
        private MirroringPolicy policyMirroring;
        private boolean policyLearning$set;
        private LearningPolicy policyLearning;
        private boolean policyReset$set;
        private ResetPolicy policyReset;
        private boolean policyLocation$set;
        private LocationPolicy policyLocation;
        private boolean tempFilePath$set;
        private String tempFilePath;
        private boolean initialSize$set;
        private long initialSize;
        private boolean minSize$set;
        private long minSize;
        private boolean maxSize$set;
        private long maxSize;
        private boolean cyclesBeforeInitialization$set;
        private int cyclesBeforeInitialization;
        private boolean overallocationLimit$set;
        private double overallocationLimit;
        private boolean stepsNumber$set;
        private int stepsNumber;

        WorkspaceConfigurationBuilder() {
        }

        public WorkspaceConfigurationBuilder policyAllocation(AllocationPolicy policyAllocation) {
            this.policyAllocation = policyAllocation;
            this.policyAllocation$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder policySpill(SpillPolicy policySpill) {
            this.policySpill = policySpill;
            this.policySpill$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder policyMirroring(MirroringPolicy policyMirroring) {
            this.policyMirroring = policyMirroring;
            this.policyMirroring$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder policyLearning(LearningPolicy policyLearning) {
            this.policyLearning = policyLearning;
            this.policyLearning$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder policyReset(ResetPolicy policyReset) {
            this.policyReset = policyReset;
            this.policyReset$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder policyLocation(LocationPolicy policyLocation) {
            this.policyLocation = policyLocation;
            this.policyLocation$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder tempFilePath(String tempFilePath) {
            this.tempFilePath = tempFilePath;
            this.tempFilePath$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder initialSize(long initialSize) {
            this.initialSize = initialSize;
            this.initialSize$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder minSize(long minSize) {
            this.minSize = minSize;
            this.minSize$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder maxSize(long maxSize) {
            this.maxSize = maxSize;
            this.maxSize$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder cyclesBeforeInitialization(int cyclesBeforeInitialization) {
            this.cyclesBeforeInitialization = cyclesBeforeInitialization;
            this.cyclesBeforeInitialization$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder overallocationLimit(double overallocationLimit) {
            this.overallocationLimit = overallocationLimit;
            this.overallocationLimit$set = true;
            return this;
        }

        public WorkspaceConfigurationBuilder stepsNumber(int stepsNumber) {
            this.stepsNumber = stepsNumber;
            this.stepsNumber$set = true;
            return this;
        }

        public WorkspaceConfiguration build() {
            AllocationPolicy policyAllocation = this.policyAllocation;
            if (!this.policyAllocation$set) {
                policyAllocation = WorkspaceConfiguration.$default$policyAllocation();
            }
            SpillPolicy policySpill = this.policySpill;
            if (!this.policySpill$set) {
                policySpill = WorkspaceConfiguration.$default$policySpill();
            }
            MirroringPolicy policyMirroring = this.policyMirroring;
            if (!this.policyMirroring$set) {
                policyMirroring = WorkspaceConfiguration.$default$policyMirroring();
            }
            LearningPolicy policyLearning = this.policyLearning;
            if (!this.policyLearning$set) {
                policyLearning = WorkspaceConfiguration.$default$policyLearning();
            }
            ResetPolicy policyReset = this.policyReset;
            if (!this.policyReset$set) {
                policyReset = WorkspaceConfiguration.$default$policyReset();
            }
            LocationPolicy policyLocation = this.policyLocation;
            if (!this.policyLocation$set) {
                policyLocation = WorkspaceConfiguration.$default$policyLocation();
            }
            String tempFilePath = this.tempFilePath;
            if (!this.tempFilePath$set) {
                tempFilePath = WorkspaceConfiguration.$default$tempFilePath();
            }
            long initialSize = this.initialSize;
            if (!this.initialSize$set) {
                initialSize = WorkspaceConfiguration.$default$initialSize();
            }
            long minSize = this.minSize;
            if (!this.minSize$set) {
                minSize = WorkspaceConfiguration.$default$minSize();
            }
            long maxSize = this.maxSize;
            if (!this.maxSize$set) {
                maxSize = WorkspaceConfiguration.$default$maxSize();
            }
            int cyclesBeforeInitialization = this.cyclesBeforeInitialization;
            if (!this.cyclesBeforeInitialization$set) {
                cyclesBeforeInitialization = WorkspaceConfiguration.$default$cyclesBeforeInitialization();
            }
            double overallocationLimit = this.overallocationLimit;
            if (!this.overallocationLimit$set) {
                overallocationLimit = WorkspaceConfiguration.$default$overallocationLimit();
            }
            int stepsNumber = this.stepsNumber;
            if (!this.stepsNumber$set) {
                stepsNumber = WorkspaceConfiguration.$default$stepsNumber();
            }
            return new WorkspaceConfiguration(policyAllocation, policySpill, policyMirroring, policyLearning, policyReset, policyLocation, tempFilePath, initialSize, minSize, maxSize, cyclesBeforeInitialization, overallocationLimit, stepsNumber);
        }

        public String toString() {
            return "WorkspaceConfiguration.WorkspaceConfigurationBuilder(policyAllocation=" + (Object)((Object)this.policyAllocation) + ", policySpill=" + (Object)((Object)this.policySpill) + ", policyMirroring=" + (Object)((Object)this.policyMirroring) + ", policyLearning=" + (Object)((Object)this.policyLearning) + ", policyReset=" + (Object)((Object)this.policyReset) + ", policyLocation=" + (Object)((Object)this.policyLocation) + ", tempFilePath=" + this.tempFilePath + ", initialSize=" + this.initialSize + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", cyclesBeforeInitialization=" + this.cyclesBeforeInitialization + ", overallocationLimit=" + this.overallocationLimit + ", stepsNumber=" + this.stepsNumber + ")";
        }
    }
}

