/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.validation;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.nd4j.common.validation.ValidationResult;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.type.MapType;

public class Nd4jCommonValidator {
    private Nd4jCommonValidator() {
    }

    public static ValidationResult isValidFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile(f, "File", false);
        if (vr != null) {
            return vr;
        }
        return ValidationResult.builder().valid(true).formatType("File").path(Nd4jCommonValidator.getPath(f)).build();
    }

    public static ValidationResult isValidFile(@NonNull File f, String formatType, boolean allowEmpty) {
        String path;
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        try {
            path = f.getAbsolutePath();
        }
        catch (Throwable t) {
            path = f.getPath();
        }
        if (f.exists() && !f.isFile()) {
            return ValidationResult.builder().valid(false).formatType(formatType).path(path).issues(Collections.singletonList(f.isDirectory() ? "Specified path is a directory" : "Specified path is not a file")).build();
        }
        if (!f.exists() || !f.isFile()) {
            return ValidationResult.builder().valid(false).formatType(formatType).path(path).issues(Collections.singletonList("File does not exist")).build();
        }
        if (!allowEmpty && f.length() <= 0L) {
            return ValidationResult.builder().valid(false).formatType(formatType).path(path).issues(Collections.singletonList("File is empty (length 0)")).build();
        }
        return null;
    }

    public static ValidationResult isValidJsonUTF8(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        return Nd4jCommonValidator.isValidJson(f, StandardCharsets.UTF_8);
    }

    public static ValidationResult isValidJson(@NonNull File f, Charset charset) {
        String content;
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile(f, "JSON", false);
        if (vr != null) {
            return vr;
        }
        try {
            content = FileUtils.readFileToString((File)f, (Charset)charset);
        }
        catch (IOException e) {
            return ValidationResult.builder().valid(false).formatType("JSON").path(Nd4jCommonValidator.getPath(f)).issues(Collections.singletonList("Unable to read file (IOException)")).exception(e).build();
        }
        return Nd4jCommonValidator.isValidJson(content, f);
    }

    public static ValidationResult isValidJSON(String s) {
        return Nd4jCommonValidator.isValidJson(s, null);
    }

    protected static ValidationResult isValidJson(String content, File f) {
        try {
            ObjectMapper om = new ObjectMapper();
            MapType javaType = om.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
            om.readValue(content, (JavaType)javaType);
        }
        catch (Throwable t) {
            return ValidationResult.builder().valid(false).formatType("JSON").path(Nd4jCommonValidator.getPath(f)).issues(Collections.singletonList("File does not appear to be valid JSON")).exception(t).build();
        }
        return ValidationResult.builder().valid(true).formatType("JSON").path(Nd4jCommonValidator.getPath(f)).build();
    }

    public static ValidationResult isValidZipFile(@NonNull File f, boolean allowEmpty) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        return Nd4jCommonValidator.isValidZipFile(f, allowEmpty, (List<String>)null);
    }

    public static ValidationResult isValidZipFile(@NonNull File f, boolean allowEmpty, String ... requiredEntries) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        return Nd4jCommonValidator.isValidZipFile(f, allowEmpty, requiredEntries == null ? null : Arrays.asList(requiredEntries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ValidationResult isValidZipFile(@NonNull File f, boolean allowEmpty, List<String> requiredEntries) {
        block24: {
            ZipFile zf;
            block23: {
                block22: {
                    if (f == null) {
                        throw new NullPointerException("f is marked non-null but is null");
                    }
                    ValidationResult vr = Nd4jCommonValidator.isValidFile(f, "Zip File", false);
                    if (vr != null) {
                        return vr;
                    }
                    try {
                        zf = new ZipFile(f);
                    }
                    catch (Throwable e) {
                        return ValidationResult.builder().valid(false).formatType("Zip File").path(Nd4jCommonValidator.getPath(f)).issues(Collections.singletonList("File does not appear to be valid zip file (not a zip file or content is corrupt)")).exception(e).build();
                    }
                    int numEntries = zf.size();
                    if (allowEmpty || numEntries > 0) break block22;
                    ValidationResult validationResult = ValidationResult.builder().valid(false).formatType("Zip File").path(Nd4jCommonValidator.getPath(f)).issues(Collections.singletonList("Zip file is empty")).build();
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return validationResult;
                }
                if (requiredEntries == null || requiredEntries.isEmpty()) break block23;
                ArrayList<String> missing = null;
                for (String s : requiredEntries) {
                    ZipEntry ze = zf.getEntry(s);
                    if (ze != null) continue;
                    if (missing == null) {
                        missing = new ArrayList<String>();
                    }
                    missing.add(s);
                }
                if (missing == null) break block23;
                String s = "Zip file is missing " + missing.size() + " of " + requiredEntries.size() + " required entries: " + missing;
                ValidationResult validationResult = ValidationResult.builder().valid(false).formatType("Zip File").path(Nd4jCommonValidator.getPath(f)).issues(Collections.singletonList(s)).build();
                try {
                    zf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return validationResult;
            }
            try {
                zf.close();
            }
            catch (IOException numEntries) {}
            break block24;
            catch (Throwable t) {
                try {
                    ValidationResult validationResult = ValidationResult.builder().valid(false).formatType("Zip File").path(Nd4jCommonValidator.getPath(f)).issues(Collections.singletonList("Error reading zip file")).exception(t).build();
                    return validationResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return ValidationResult.builder().valid(true).formatType("Zip File").path(Nd4jCommonValidator.getPath(f)).build();
    }

    public static String getPath(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getAbsolutePath();
        }
        catch (Throwable t) {
            return f.getPath();
        }
    }
}

