/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Atomic<T extends Serializable>
implements Serializable {
    private volatile T value;
    private transient ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public Atomic(T initialValue) {
        this.value = initialValue;
    }

    public void set(T value) {
        try {
            this.lock.writeLock().lock();
            this.value = value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public T get() {
        try {
            this.lock.readLock().lock();
            T t = this.value;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cas(T expected, T newValue) {
        try {
            this.lock.writeLock().lock();
            if (Objects.equals(this.value, expected)) {
                this.value = newValue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = new ReentrantReadWriteLock();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Atomic atomic = (Atomic)o;
        try {
            this.lock.readLock().lock();
            atomic.lock.readLock().lock();
            boolean bl = Objects.equals(this.value, atomic.value);
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            atomic.lock.readLock().unlock();
            this.lock.readLock().unlock();
        }
    }

    public int hashCode() {
        try {
            this.lock.readLock().lock();
            int n = Objects.hash(this.value);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Atomic() {
    }
}

