/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.primitives;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SynchronizedObject<T>
implements Serializable {
    protected T value;
    protected transient ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SynchronizedObject() {
    }

    public SynchronizedObject(T value) {
        this();
        this.set(value);
    }

    public final T get() {
        try {
            this.lock.readLock().lock();
            T t = this.value;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public final void set(T value) {
        try {
            this.lock.writeLock().lock();
            this.value = value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

