/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.collections;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    protected final Map<KeyRef<K>, V> map = new HashMap<KeyRef<K>, V>();
    protected final ReferenceQueue<K> refQueue = new ReferenceQueue();

    protected void clearReferences() {
        Reference<K> r;
        while ((r = this.refQueue.poll()) != null) {
            this.map.remove(r);
        }
    }

    @Override
    public int size() {
        this.clearReferences();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.clearReferences();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.clearReferences();
        return this.map.containsKey(new KeyRef<Object>(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.clearReferences();
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.clearReferences();
        return this.map.get(new KeyRef<Object>(key));
    }

    @Override
    public V put(K key, V value) {
        this.clearReferences();
        this.map.put(new KeyRef<K>(key), value);
        return value;
    }

    @Override
    public V remove(Object key) {
        this.clearReferences();
        return this.map.remove(new KeyRef<Object>(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.clearReferences();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.map.put(new KeyRef<K>(e.getKey()), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.clearReferences();
    }

    @Override
    public Set<K> keySet() {
        this.clearReferences();
        HashSet ret = new HashSet();
        for (KeyRef<K> k : this.map.keySet()) {
            Object key = k.get();
            if (key == null) continue;
            ret.add(key);
        }
        return ret;
    }

    @Override
    public Collection<V> values() {
        this.clearReferences();
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.clearReferences();
        HashSet<Map.Entry<K, V>> ret = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<KeyRef<K>, V> e : this.map.entrySet()) {
            Object k = e.getKey().get();
            if (k == null) continue;
            ret.add(new Entry(k, e.getValue()));
        }
        return ret;
    }

    protected static class Entry<K, V>
    implements Map.Entry<K, V> {
        protected K key;
        protected V value;

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public void setKey(K key) {
            this.key = key;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$key = this.getKey();
            K other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            V this$value = this.getValue();
            V other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "WeakIdentityHashMap.Entry(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }

    protected static class KeyRef<K>
    extends WeakReference<K> {
        private final int hash;

        public KeyRef(@NonNull K referent) {
            super(referent);
            if (referent == null) {
                throw new NullPointerException("referent is marked @NonNull but is null");
            }
            this.hash = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof WeakReference) {
                return this.get() == ((WeakReference)o).get();
            }
            return false;
        }
    }
}

