/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.resources;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import lombok.NonNull;
import org.nd4j.common.resources.Resolver;
import org.nd4j.common.resources.strumpf.StrumpfResolver;

public class Resources {
    private static Resources INSTANCE = new Resources();
    protected final List<Resolver> resolvers;

    protected Resources() {
        ServiceLoader<Resolver> loader = ServiceLoader.load(Resolver.class);
        Iterator<Resolver> iter = loader.iterator();
        this.resolvers = new ArrayList<Resolver>();
        this.resolvers.add(new StrumpfResolver());
        while (iter.hasNext()) {
            Resolver r = iter.next();
            this.resolvers.add(r);
        }
        Collections.sort(this.resolvers, new Comparator<Resolver>(){

            @Override
            public int compare(Resolver r1, Resolver r2) {
                return Integer.compare(r1.priority(), r2.priority());
            }
        });
    }

    public static boolean exists(@NonNull String resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        return INSTANCE.resourceExists(resourcePath);
    }

    public static File asFile(@NonNull String resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        return INSTANCE.getAsFile(resourcePath);
    }

    public static InputStream asStream(@NonNull String resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        return INSTANCE.getAsStream(resourcePath);
    }

    public static void copyDirectory(@NonNull String directoryPath, @NonNull File destinationDir) {
        if (directoryPath == null) {
            throw new NullPointerException("directoryPath is marked non-null but is null");
        }
        if (destinationDir == null) {
            throw new NullPointerException("destinationDir is marked non-null but is null");
        }
        INSTANCE.copyDir(directoryPath, destinationDir);
    }

    public static String normalizePath(String path) {
        return INSTANCE.normalize(path);
    }

    protected boolean resourceExists(String resourcePath) {
        for (Resolver r : this.resolvers) {
            if (!r.exists(resourcePath)) continue;
            return true;
        }
        return false;
    }

    protected File getAsFile(String resourcePath) {
        for (Resolver r : this.resolvers) {
            if (!r.exists(resourcePath)) continue;
            return r.asFile(resourcePath);
        }
        throw new IllegalStateException("Cannot resolve resource (not found): none of " + this.resolvers.size() + " resolvers can resolve resource \"" + resourcePath + "\" - available resolvers: " + this.resolvers.toString());
    }

    public InputStream getAsStream(String resourcePath) {
        for (Resolver r : this.resolvers) {
            if (!r.exists(resourcePath)) continue;
            return r.asStream(resourcePath);
        }
        throw new IllegalStateException("Cannot resolve resource (not found): none of " + this.resolvers.size() + " resolvers can resolve resource \"" + resourcePath + "\" - available resolvers: " + this.resolvers.toString());
    }

    public void copyDir(String directoryPath, File destinationDir) {
        for (Resolver r : this.resolvers) {
            if (!r.directoryExists(directoryPath)) continue;
            r.copyDirectory(directoryPath, destinationDir);
            return;
        }
    }

    public String normalize(String path) {
        for (Resolver r : this.resolvers) {
            path = r.normalizePath(path);
        }
        return path;
    }
}

