/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.io.Resource;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nd4jBackend {
    public static final int BACKEND_PRIORITY_CPU = 0;
    public static final int BACKEND_PRIORITY_GPU = 100;
    private static final Logger log = LoggerFactory.getLogger(Nd4jBackend.class);

    public abstract boolean allowsOrder();

    public abstract int getPriority();

    public abstract boolean isAvailable();

    public abstract boolean canRun();

    public abstract Resource getConfigurationResource();

    public abstract Class getNDArrayClass();

    public abstract Class getComplexNDArrayClass();

    public static Nd4jBackend load() throws NoAvailableBackendException {
        ArrayList<Nd4jBackend> backends = new ArrayList<Nd4jBackend>(1);
        ServiceLoader<Nd4jBackend> loader = ServiceLoader.load(Nd4jBackend.class);
        try {
            Iterator<Nd4jBackend> backendIterator = loader.iterator();
            while (backendIterator.hasNext()) {
                backends.add(backendIterator.next());
            }
        }
        catch (ServiceConfigurationError serviceError) {
            throw new RuntimeException("failed to process available backends", serviceError);
        }
        Collections.sort(backends, new Comparator<Nd4jBackend>(){

            @Override
            public int compare(Nd4jBackend o1, Nd4jBackend o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        for (Nd4jBackend backend : backends) {
            if (!backend.isAvailable()) {
                log.trace("Skipped [{}] backend (unavailable)", (Object)backend.getClass().getSimpleName());
                continue;
            }
            try {
                Nd4jContext.getInstance().updateProperties(backend.getConfigurationResource().getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            log.trace("Loaded [{}] backend", (Object)backend.getClass().getSimpleName());
            return backend;
        }
        log.trace("Service loader failed...falling back to reflection");
        Set clazzes = new Reflections("org.nd4j", new Scanner[0]).getSubTypesOf(Nd4jBackend.class);
        ArrayList<Nd4jBackend> reflectionBackends = new ArrayList<Nd4jBackend>();
        for (Class clazz : clazzes) {
            try {
                Nd4jBackend load = (Nd4jBackend)clazz.newInstance();
                reflectionBackends.add(load);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(backends, new Comparator<Nd4jBackend>(){

            @Override
            public int compare(Nd4jBackend o1, Nd4jBackend o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        for (Nd4jBackend nd4jBackend : reflectionBackends) {
            if (!nd4jBackend.isAvailable()) {
                log.trace("Skipped [{}] backend (unavailable)", (Object)nd4jBackend.getClass().getSimpleName());
                continue;
            }
            try {
                Nd4jContext.getInstance().updateProperties(nd4jBackend.getConfigurationResource().getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            log.info("Loaded [{}] backend", (Object)nd4jBackend.getClass().getSimpleName());
            return nd4jBackend;
        }
        throw new NoAvailableBackendException("Please ensure that you have an nd4j backend on your classpath. Please see: http://nd4j.org/getstarted.html");
    }

    public Properties getProperties() throws IOException {
        return this.getContext().getConf();
    }

    public Nd4jContext getContext() throws IOException {
        return Nd4jContext.getInstance();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static class NoAvailableBackendException
    extends Exception {
        public NoAvailableBackendException(String s) {
            super(s);
        }
    }
}

