/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas;

import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.jcublas.buffer.JCudaBuffer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CublasPointer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CublasPointer.class);
    private JCudaBuffer buffer;
    private Pointer devicePointer;
    private Pointer hostPointer;
    private boolean closed = false;
    private INDArray arr;
    private CudaContext cudaContext;
    private boolean resultPointer = false;

    @Override
    public void close() throws Exception {
        if (!this.isResultPointer()) {
            this.destroy();
        }
    }

    public void destroy() {
    }

    public JCudaBuffer getBuffer() {
        return this.buffer;
    }

    public Pointer getDevicePointer() {
        return this.devicePointer;
    }

    public Pointer getHostPointer() {
        return this.hostPointer;
    }

    public void setHostPointer(Pointer hostPointer) {
        this.hostPointer = hostPointer;
    }

    public CublasPointer(JCudaBuffer buffer, CudaContext context) {
        this.buffer = buffer;
        this.cudaContext = context;
    }

    public CublasPointer(INDArray array, CudaContext context) {
        this.cudaContext = context;
        this.devicePointer = AtomicAllocator.getInstance().getPointer(array, context);
    }

    public boolean isResultPointer() {
        return this.resultPointer;
    }

    public void setResultPointer(boolean resultPointer) {
        this.resultPointer = resultPointer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NativePointer: [" + this.devicePointer.address() + "]");
        return sb.toString();
    }

    public static void free(CublasPointer ... pointers) {
        for (CublasPointer pointer : pointers) {
            try {
                pointer.close();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

