/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.garbage.GarbageBufferReference;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.pointers.PointersPair;
import org.nd4j.jita.allocator.pointers.cuda.cudaEvent_t;
import org.nd4j.jita.allocator.time.TimeProvider;
import org.nd4j.jita.allocator.time.providers.OperativeProvider;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationPoint {
    private static Logger log = LoggerFactory.getLogger(AllocationPoint.class);
    private volatile PointersPair pointerInfo;
    private Long objectId;
    private Long bucketId;
    private boolean isAttached = false;
    private volatile boolean released = false;
    private AllocationStatus allocationStatus = AllocationStatus.UNDEFINED;
    private transient TimeProvider timeProvider = new OperativeProvider();
    private long accessHostRead = 0L;
    private long accessDeviceRead = 0L;
    private long accessHostWrite = 0L;
    private long accessDeviceWrite = 0L;
    protected static final NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private boolean constant;
    private volatile int deviceId;
    private AllocationShape shape;
    private AtomicBoolean enqueued = new AtomicBoolean(false);
    private cudaEvent_t lastWriteEvent;
    private cudaEvent_t lastReadEvent;
    private volatile CudaContext currentContext;

    public void acquireLock() {
    }

    public void releaseLock() {
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public boolean isEnqueued() {
        return this.enqueued.get();
    }

    public void markEnqueued(boolean reallyEnqueued) {
        this.enqueued.set(reallyEnqueued);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CudaContext getCurrentContext() {
        AllocationPoint allocationPoint = this;
        synchronized (allocationPoint) {
            return this.currentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentContext(CudaContext context) {
        AllocationPoint allocationPoint = this;
        synchronized (allocationPoint) {
            this.currentContext = context;
        }
    }

    public long getNumberOfBytes() {
        return this.shape.getNumberOfBytes();
    }

    public void attachBuffer(@NonNull BaseDataBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
    }

    public void attachReference(GarbageBufferReference reference) {
    }

    public DataBuffer getBuffer() {
        return null;
    }

    public AllocationStatus getAllocationStatus() {
        return this.allocationStatus;
    }

    public void setAllocationStatus(@NonNull AllocationStatus status) {
        if (status == null) {
            throw new NullPointerException("status is marked @NonNull but is null");
        }
        this.allocationStatus = status;
    }

    public Pointer getDevicePointer() {
        if (this.pointerInfo == null) {
            log.info("pointerInfo is null");
            return null;
        }
        return this.pointerInfo.getDevicePointer();
    }

    public Pointer getHostPointer() {
        if (this.pointerInfo == null) {
            return null;
        }
        return this.pointerInfo.getHostPointer();
    }

    public void setPointers(@NonNull PointersPair pointerInfo) {
        if (pointerInfo == null) {
            throw new NullPointerException("pointerInfo is marked @NonNull but is null");
        }
        this.pointerInfo = pointerInfo;
    }

    public PointersPair getPointers() {
        return this.pointerInfo;
    }

    public synchronized void tickDeviceRead() {
        this.accessDeviceRead = this.timeProvider.getCurrentTime();
    }

    public synchronized long getHostReadTime() {
        return this.accessHostRead;
    }

    public synchronized long getHostWriteTime() {
        return this.accessHostWrite;
    }

    public synchronized long getDeviceAccessTime() {
        return this.accessDeviceRead;
    }

    public synchronized long getDeviceWriteTime() {
        return this.accessDeviceWrite;
    }

    public synchronized void tickHostRead() {
        this.accessHostRead = this.timeProvider.getCurrentTime();
    }

    public synchronized void tickDeviceWrite() {
        this.tickDeviceRead();
        this.accessDeviceWrite = this.timeProvider.getCurrentTime();
    }

    public synchronized void tickHostWrite() {
        this.tickHostRead();
        this.accessHostWrite = this.timeProvider.getCurrentTime();
    }

    public synchronized boolean isActualOnHostSide() {
        boolean result = this.accessHostWrite >= this.accessDeviceWrite || this.accessHostRead >= this.accessDeviceWrite;
        return result;
    }

    public synchronized boolean isActualOnDeviceSide() {
        boolean result = this.accessDeviceWrite >= this.accessHostWrite || this.accessDeviceRead >= this.accessHostWrite;
        return result;
    }

    public synchronized void tickDeviceToHost() {
        this.accessDeviceRead = this.accessHostRead;
    }

    public String toString() {
        return "AllocationPoint{deviceId=" + this.deviceId + ", objectId=" + this.objectId + ", shape=" + this.shape + '}';
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public Long getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(Long bucketId) {
        this.bucketId = bucketId;
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public void setAttached(boolean isAttached) {
        this.isAttached = isAttached;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public AllocationShape getShape() {
        return this.shape;
    }

    public void setShape(AllocationShape shape) {
        this.shape = shape;
    }

    public cudaEvent_t getLastWriteEvent() {
        return this.lastWriteEvent;
    }

    public void setLastWriteEvent(cudaEvent_t lastWriteEvent) {
        this.lastWriteEvent = lastWriteEvent;
    }

    public cudaEvent_t getLastReadEvent() {
        return this.lastReadEvent;
    }

    public void setLastReadEvent(cudaEvent_t lastReadEvent) {
        this.lastReadEvent = lastReadEvent;
    }
}

