/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.impl;

import lombok.NonNull;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.impl.AllocationPoint;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaDeallocator
implements Deallocator {
    private static final Logger log = LoggerFactory.getLogger(CudaDeallocator.class);
    private AllocationPoint point;

    public CudaDeallocator(@NonNull BaseCudaDataBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        this.point = buffer.getAllocationPoint();
        if (this.point == null) {
            throw new RuntimeException();
        }
    }

    public void deallocate() {
        log.trace("Deallocating CUDA memory");
        if (this.point.isAttached() || this.point.isReleased()) {
            if (!AtomicAllocator.getInstance().allocationsMap().containsKey(this.point.getObjectId())) {
                return;
            }
            AtomicAllocator.getInstance().getFlowController().waitTillReleased(this.point);
            AtomicAllocator.getInstance().getFlowController().getEventsProvider().storeEvent(this.point.getLastWriteEvent());
            AtomicAllocator.getInstance().getFlowController().getEventsProvider().storeEvent(this.point.getLastReadEvent());
            AtomicAllocator.getInstance().allocationsMap().remove(this.point.getObjectId());
            return;
        }
        if (this.point.getAllocationStatus() == AllocationStatus.HOST) {
            AtomicAllocator.getInstance().purgeZeroObject(this.point.getBucketId(), this.point.getObjectId(), this.point, false);
        } else if (this.point.getAllocationStatus() == AllocationStatus.DEVICE) {
            AtomicAllocator.getInstance().purgeDeviceObject(0L, this.point.getDeviceId(), this.point.getObjectId(), this.point, false);
            AtomicAllocator.getInstance().purgeZeroObject(this.point.getBucketId(), this.point.getObjectId(), this.point, false);
        }
    }
}

