/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.tad;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.TadPack;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTADManager
implements TADManager {
    protected NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private static Logger logger = LoggerFactory.getLogger(BasicTADManager.class);
    protected AtomicLong bytes = new AtomicLong(0L);

    public Pair<DataBuffer, DataBuffer> getTADOnlyShapeInfo(INDArray array, int[] dimension) {
        if (dimension != null && dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if (dimension == null) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        TadPack pack = Nd4j.getExecutioner().tadShapeInfoAndOffsets(array, dimension);
        return new Pair((Object)pack.getTadShapeInfo(), (Object)pack.getTadOffsets());
    }

    public void purgeBuffers() {
    }

    public long getCachedBytes() {
        return this.bytes.get();
    }
}

