/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.jita.allocator.pointers.cuda.cudaEvent_t;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOpsHolder;

public class EventsProvider {
    private List<ConcurrentLinkedQueue<cudaEvent_t>> queue = new ArrayList<ConcurrentLinkedQueue<cudaEvent_t>>();
    private AtomicLong newCounter = new AtomicLong(0L);
    private AtomicLong cacheCounter = new AtomicLong(0L);

    public EventsProvider() {
        int numDev = Nd4j.getAffinityManager().getNumberOfDevices();
        for (int i = 0; i < numDev; ++i) {
            this.queue.add(new ConcurrentLinkedQueue());
        }
    }

    public cudaEvent_t getEvent() {
        int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        cudaEvent_t e = this.queue.get(deviceId).poll();
        if (e == null) {
            e = new cudaEvent_t(NativeOpsHolder.getInstance().getDeviceNativeOps().createEvent());
            e.setDeviceId(deviceId);
            this.newCounter.incrementAndGet();
        } else {
            this.cacheCounter.incrementAndGet();
        }
        return e;
    }

    public void storeEvent(cudaEvent_t event) {
        if (event != null) {
            this.queue.get(event.getDeviceId()).add(event);
        }
    }

    public long getEventsNumber() {
        return this.newCounter.get();
    }

    public long getCachedNumber() {
        return this.cacheCounter.get();
    }
}

