/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.enums.CudaConstants;
import org.nd4j.jita.allocator.impl.AllocationPoint;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.impl.CudaDeallocator;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.pointers.PointersPair;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.buffer.JCudaBuffer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.memory.MemcpyDirection;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LongUtils;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCudaDataBuffer
extends BaseDataBuffer
implements JCudaBuffer,
Deallocatable {
    protected volatile transient AllocationPoint allocationPoint;
    private static AtomicAllocator allocator = AtomicAllocator.getInstance();
    private static Logger log = LoggerFactory.getLogger(BaseCudaDataBuffer.class);
    protected DataType globalType = DataTypeUtil.getDtypeFromContext();

    public BaseCudaDataBuffer() {
    }

    public BaseCudaDataBuffer(@NonNull Pointer pointer, @NonNull Pointer specialPointer, @NonNull Indexer indexer, long length) {
        if (pointer == null) {
            throw new NullPointerException("pointer is marked @NonNull but is null");
        }
        if (specialPointer == null) {
            throw new NullPointerException("specialPointer is marked @NonNull but is null");
        }
        if (indexer == null) {
            throw new NullPointerException("indexer is marked @NonNull but is null");
        }
        this.allocationPoint = AtomicAllocator.getInstance().pickExternalBuffer(this);
        this.allocationPoint.setPointers(new PointersPair(specialPointer, pointer));
        this.trackingPoint = this.allocationPoint.getObjectId();
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.indexer = indexer;
        this.offset = 0L;
        this.originalOffset = 0L;
        this.underlyingLength = length;
        this.length = length;
        this.initTypeAndSize();
    }

    public BaseCudaDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
        this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(length, this.elementSize, this.dataType()), false);
        this.trackingPoint = this.allocationPoint.getObjectId();
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        CudaContext context = AtomicAllocator.getInstance().getDeviceContext();
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        if (this.allocationPoint.getHostPointer() != null) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().memcpyAsync(this.allocationPoint.getHostPointer(), pointer, length * (long)this.getElementSize(), CudaConstants.cudaMemcpyHostToHost, (Pointer)context.getSpecialStream());
            NativeOpsHolder.getInstance().getDeviceNativeOps().memcpyAsync(this.allocationPoint.getDevicePointer(), this.allocationPoint.getHostPointer(), length * (long)this.getElementSize(), CudaConstants.cudaMemcpyHostToHost, (Pointer)context.getSpecialStream());
        } else {
            NativeOpsHolder.getInstance().getDeviceNativeOps().memcpyAsync(this.allocationPoint.getDevicePointer(), pointer, length * (long)this.getElementSize(), CudaConstants.cudaMemcpyHostToDevice, (Pointer)context.getSpecialStream());
        }
        context.getSpecialStream().synchronize();
        if (this.allocationPoint.getHostPointer() != null) {
            PerformanceTracker.getInstance().helperRegisterTransaction(this.allocationPoint.getDeviceId(), perfD / 2L, this.allocationPoint.getNumberOfBytes(), MemcpyDirection.HOST_TO_HOST);
        }
        PerformanceTracker.getInstance().helperRegisterTransaction(this.allocationPoint.getDeviceId(), perfD / 2L, this.allocationPoint.getNumberOfBytes(), MemcpyDirection.HOST_TO_DEVICE);
    }

    public BaseCudaDataBuffer(float[] data, boolean copy) {
        this(data, copy, 0L);
    }

    public BaseCudaDataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        this(data, copy, 0L, workspace);
    }

    public BaseCudaDataBuffer(float[] data, boolean copy, long offset) {
        this((long)data.length, 4, false);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(double[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data.length, 8, false, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data.length, 4, false, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(double[] data, boolean copy) {
        this(data, copy, 0L);
    }

    public BaseCudaDataBuffer(double[] data, boolean copy, long offset) {
        this((long)data.length, 8, false);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy) {
        this(data, copy, 0L);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy, MemoryWorkspace workspace) {
        this(data, copy, 0L, workspace);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy, long offset) {
        this((long)data.length, 4, false);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data.length, 4, false, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    protected void initPointers(long length, DataType dtype, boolean initialize) {
        this.initPointers(length, Nd4j.sizeOfDataType((DataType)dtype), initialize);
    }

    public void lazyAllocateHostPointer() {
        if (this.allocationPoint.getPointers().getHostPointer() == null) {
            this.initHostPointerAndIndexer();
        }
    }

    protected void initHostPointerAndIndexer() {
        if (this.allocationPoint.getPointers().getHostPointer() == null) {
            AllocationStatus location = this.allocationPoint.getAllocationStatus();
            if (this.parentWorkspace == null) {
                PointersPair ptr = AtomicAllocator.getInstance().getMemoryHandler().alloc(AllocationStatus.HOST, this.allocationPoint, this.allocationPoint.getShape(), false);
                this.allocationPoint.getPointers().setHostPointer(ptr.getHostPointer());
            } else {
                PagedPointer ptr = this.parentWorkspace.alloc(this.length * (long)this.elementSize, MemoryKind.HOST, this.dataType(), false);
                this.allocationPoint.getPointers().setHostPointer((Pointer)ptr);
            }
            this.allocationPoint.setAllocationStatus(location);
            this.allocationPoint.tickDeviceWrite();
        }
        switch (this.dataType()) {
            case DOUBLE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asDoublePointer();
                this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                break;
            }
            case FLOAT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asFloatPointer();
                this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                break;
            }
            case UINT32: 
            case INT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asIntPointer();
                this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                break;
            }
            case BFLOAT16: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asShortPointer();
                this.indexer = Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case HALF: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asShortPointer();
                this.indexer = HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case UINT64: 
            case LONG: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asLongPointer();
                this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                break;
            }
            case UINT16: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asShortPointer();
                this.indexer = UShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case SHORT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asShortPointer();
                this.indexer = ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case UBYTE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asBytePointer();
                this.indexer = UByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                break;
            }
            case BYTE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asBytePointer();
                this.indexer = ByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                break;
            }
            case BOOL: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length, 0L).asBooleanPointer();
                this.indexer = BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void initPointers(long length, int elementSize, boolean initialize) {
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(length, elementSize, this.dataType()), initialize);
        this.length = length;
        this.elementSize = (byte)elementSize;
        this.trackingPoint = this.allocationPoint.getObjectId();
        this.offset = 0L;
        this.originalOffset = 0L;
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        if (this.allocationPoint.getPointers().getHostPointer() == null) {
            return;
        }
        this.initHostPointerAndIndexer();
    }

    public BaseCudaDataBuffer(long length, int elementSize, boolean initialize) {
        this.initTypeAndSize();
        this.initPointers(length, elementSize, initialize);
    }

    public BaseCudaDataBuffer(long length, int elementSize, boolean initialize, @NonNull MemoryWorkspace workspace) {
        if (workspace == null) {
            throw new NullPointerException("workspace is marked @NonNull but is null");
        }
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.initTypeAndSize();
        this.attached = true;
        this.parentWorkspace = workspace;
        this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(length, this.elementSize, this.dataType()), initialize);
        this.length = length;
        this.trackingPoint = this.allocationPoint.getObjectId();
        this.offset = 0L;
        this.originalOffset = 0L;
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.attached = true;
        this.parentWorkspace = workspace;
        if (this.allocationPoint.getHostPointer() == null) {
            return;
        }
        switch (this.dataType()) {
            case DOUBLE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asDoublePointer();
                this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                break;
            }
            case FLOAT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asFloatPointer();
                this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                break;
            }
            case UINT32: 
            case INT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asIntPointer();
                this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                break;
            }
            case BFLOAT16: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asShortPointer();
                this.indexer = Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case HALF: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asShortPointer();
                this.indexer = HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case UINT64: 
            case LONG: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asLongPointer();
                this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                break;
            }
            case BOOL: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asBooleanPointer();
                this.indexer = BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer));
                break;
            }
            case UINT16: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asShortPointer();
                this.indexer = UShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case SHORT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asShortPointer();
                this.indexer = ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case BYTE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asBytePointer();
                this.indexer = ByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                break;
            }
            case UBYTE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), length, 0L).asBytePointer();
                this.indexer = UByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type: " + this.dataType());
            }
        }
    }

    protected void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public BaseCudaDataBuffer(long length, int elementSize) {
        this(length, elementSize, true);
    }

    public BaseCudaDataBuffer(long length, int elementSize, MemoryWorkspace workspace) {
        this(length, elementSize, true, workspace);
    }

    public BaseCudaDataBuffer(long length, int elementSize, long offset) {
        this(length, elementSize);
        this.offset = offset;
        this.originalOffset = offset;
    }

    public BaseCudaDataBuffer(@NonNull DataBuffer underlyingBuffer, long length, long offset) {
        if (underlyingBuffer == null) {
            throw new NullPointerException("underlyingBuffer is marked @NonNull but is null");
        }
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.initTypeAndSize();
        this.wrappedDataBuffer = underlyingBuffer;
        this.originalBuffer = underlyingBuffer.originalDataBuffer() == null ? underlyingBuffer : underlyingBuffer.originalDataBuffer();
        this.length = length;
        this.offset = offset;
        this.originalOffset = offset;
        this.trackingPoint = underlyingBuffer.getTrackingPoint();
        this.elementSize = (byte)underlyingBuffer.getElementSize();
        this.allocationPoint = ((BaseCudaDataBuffer)underlyingBuffer).allocationPoint;
        ((BaseCudaDataBuffer)underlyingBuffer).lazyAllocateHostPointer();
        switch (underlyingBuffer.dataType()) {
            case DOUBLE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asDoublePointer();
                this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                break;
            }
            case FLOAT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asFloatPointer();
                this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                break;
            }
            case UINT32: 
            case INT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asIntPointer();
                this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                break;
            }
            case BFLOAT16: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asShortPointer();
                this.indexer = Bfloat16Indexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case HALF: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asShortPointer();
                this.indexer = HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case UINT64: 
            case LONG: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asLongPointer();
                this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                break;
            }
            case UINT16: 
            case SHORT: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asShortPointer();
                this.indexer = ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                break;
            }
            case BOOL: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asBooleanPointer();
                this.indexer = BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer));
                break;
            }
            case BYTE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asBytePointer();
                this.indexer = ByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                break;
            }
            case UBYTE: {
                this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.originalBuffer.length()).asBytePointer();
                this.indexer = UByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public BaseCudaDataBuffer(long length) {
        this(length, Nd4j.sizeOfDataType((DataType)Nd4j.dataType()));
    }

    public BaseCudaDataBuffer(float[] data) {
        this((long)data.length, Nd4j.sizeOfDataType((DataType)DataType.FLOAT), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public BaseCudaDataBuffer(int[] data) {
        this((long)data.length, Nd4j.sizeOfDataType((DataType)DataType.INT), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public BaseCudaDataBuffer(long[] data) {
        this((long)data.length, Nd4j.sizeOfDataType((DataType)DataType.LONG), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public BaseCudaDataBuffer(long[] data, boolean copy) {
        this((long)data.length, Nd4j.sizeOfDataType((DataType)DataType.LONG), false);
        if (copy) {
            this.set(data, (long)data.length, 0L, 0L);
        }
    }

    public BaseCudaDataBuffer(double[] data) {
        this((long)data.length, Nd4j.sizeOfDataType((DataType)DataType.DOUBLE), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public BaseCudaDataBuffer(byte[] data, long length, DataType type) {
        this(ByteBuffer.wrap(data), length, type);
    }

    public BaseCudaDataBuffer(ByteBuffer buffer, long length, DataType type) {
        this(buffer, length, 0L, type);
    }

    public BaseCudaDataBuffer(ByteBuffer buffer, long length, long offset, DataType type) {
        this(length, Nd4j.sizeOfDataType((DataType)type), offset);
        CudaPointer srcPtr = new CudaPointer(new Pointer((Buffer)buffer.order(ByteOrder.nativeOrder())));
        allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, offset * (long)this.elementSize);
    }

    public long address() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return this.allocationPoint.getPointers().getHostPointer().address();
    }

    public long platformAddress() {
        return this.allocationPoint.getPointers().getDevicePointer().address();
    }

    public Pointer pointer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        this.lazyAllocateHostPointer();
        return super.pointer();
    }

    public void set(int[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((int[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((int[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts((int[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case INT: {
                IntPointer pointer = new IntPointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case LONG: {
                LongPointer pointer = new LongPointer(LongUtils.toLongs((int[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs((int[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(ArrayUtil.toFloats((int[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(ArrayUtil.toDouble((int[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + this.dataType());
            }
        }
    }

    public void set(long[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                data = ArrayUtil.cutBelowZero((long[])data);
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case UINT16: {
                data = ArrayUtil.cutBelowZero((long[])data);
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UINT32: {
                data = ArrayUtil.cutBelowZero((long[])data);
            }
            case INT: {
                IntPointer pointer = new IntPointer(ArrayUtil.toInts((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UINT64: {
                data = ArrayUtil.cutBelowZero((long[])data);
            }
            case LONG: {
                LongPointer pointer = new LongPointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BFLOAT16: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toBfloats((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(ArrayUtil.toFloats((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(ArrayUtil.toDouble((long[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + this.dataType());
            }
        }
    }

    public void set(float[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((float[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((float[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts((float[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case INT: {
                IntPointer pointer = new IntPointer(ArrayUtil.toInts((float[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case LONG: {
                LongPointer pointer = new LongPointer(ArrayUtil.toLongArray((float[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs((float[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(ArrayUtil.toDoubles((float[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + this.dataType());
            }
        }
    }

    public void set(double[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((double[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes((double[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts((double[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case INT: {
                IntPointer pointer = new IntPointer(ArrayUtil.toInts((double[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case LONG: {
                LongPointer pointer = new LongPointer(ArrayUtil.toLongs((double[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs((double[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(ArrayUtil.toFloats((double[])data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + dstOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + this.dataType());
            }
        }
    }

    public void setData(int[] data) {
        this.set(data, (long)data.length, 0L, 0L);
    }

    public void setData(long[] data) {
        this.set(data, (long)data.length, 0L, 0L);
    }

    public void setData(float[] data) {
        this.set(data, (long)data.length, 0L, 0L);
    }

    public void setData(double[] data) {
        this.set(data, (long)data.length, 0L, 0L);
    }

    protected void setNioBuffer() {
        throw new UnsupportedOperationException("setNioBuffer() is not supported for CUDA backend");
    }

    public void copyAtStride(DataBuffer buf, long n, long stride, long yStride, long offset, long yOffset) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.synchronizeHostData(buf);
        super.copyAtStride(buf, n, stride, yStride, offset, yOffset);
    }

    public DataBuffer.AllocationMode allocationMode() {
        return this.allocationMode;
    }

    @Override
    public ByteBuffer getHostBuffer() {
        return this.pointer.asByteBuffer();
    }

    @Override
    public Pointer getHostPointer() {
        return AtomicAllocator.getInstance().getHostPointer(this);
    }

    @Override
    public Pointer getHostPointer(long offset) {
        throw new UnsupportedOperationException();
    }

    public void removeReferencing(String id) {
    }

    public Collection<String> references() {
        return null;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public void addReferencing(String id) {
    }

    @Deprecated
    public Pointer getHostPointer(INDArray arr, int stride, long offset, int length) {
        throw new UnsupportedOperationException("This method is deprecated");
    }

    @Deprecated
    public void set(Pointer pointer) {
        throw new UnsupportedOperationException("set(Pointer) is not supported");
    }

    public void put(long i, float element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    public void put(long i, boolean element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    public void put(long i, double element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    public void put(long i, int element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    public void put(long i, long element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    public Pointer addressPointer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return AtomicAllocator.getInstance().getHostPointer(this);
    }

    @Deprecated
    protected void set(long index, long length, Pointer from, long inc) {
        long offset = (long)this.getElementSize() * index;
        if (offset >= this.length() * (long)this.getElementSize()) {
            throw new IllegalArgumentException("Illegal offset " + offset + " with index of " + index + " and length " + this.length());
        }
        throw new UnsupportedOperationException("Deprecated set() call");
    }

    @Deprecated
    protected void set(long index, long length, Pointer from) {
        this.set(index, length, from, 1L);
    }

    public void assign(DataBuffer data) {
        allocator.memcpy(this, data);
    }

    public void assign(long[] indices, float[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Deprecated
    protected void set(long index, Pointer from) {
        this.set(index, 1L, from);
    }

    public void flush() {
    }

    public void destroy() {
    }

    public void write(DataOutputStream out) throws IOException {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        super.write(out);
    }

    public void write(OutputStream dos) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        super.write(dos);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        stream.defaultWriteObject();
        this.write(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.doReadObject(stream);
    }

    public String toString() {
        this.lazyAllocateHostPointer();
        AtomicAllocator.getInstance().synchronizeHostData(this);
        return super.toString();
    }

    public boolean sameUnderlyingData(DataBuffer buffer) {
        return buffer.getTrackingPoint() == this.getTrackingPoint();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this == o;
    }

    public void read(InputStream is, DataBuffer.AllocationMode allocationMode, long length, DataType dataType) {
        if (this.allocationPoint == null) {
            this.initPointers(length, dataType, false);
        }
        super.read(is, allocationMode, length, dataType);
        this.allocationPoint.tickHostWrite();
    }

    public void pointerIndexerByCurrentType(DataType currentType) {
    }

    public void read(DataInputStream s) {
        try {
            DataBuffer.AllocationMode savedMode = DataBuffer.AllocationMode.valueOf((String)s.readUTF());
            this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
            long locLength = 0L;
            locLength = savedMode.ordinal() < 3 ? (long)s.readInt() : s.readLong();
            boolean reallocate = locLength != this.length || this.indexer == null;
            this.length = locLength;
            DataType t = DataType.valueOf((String)s.readUTF());
            if (this.globalType == null && Nd4j.dataType() != null) {
                this.globalType = Nd4j.dataType();
            }
            if (t == DataType.COMPRESSED) {
                this.type = t;
                return;
            }
            this.elementSize = (byte)Nd4j.sizeOfDataType((DataType)t);
            this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(this.length, this.elementSize, t), false);
            this.trackingPoint = this.allocationPoint.getObjectId();
            this.type = t;
            Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
            switch (this.type) {
                case DOUBLE: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asDoublePointer();
                    this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                    break;
                }
                case FLOAT: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asFloatPointer();
                    this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                    break;
                }
                case HALF: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asShortPointer();
                    this.indexer = HalfIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case LONG: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asLongPointer();
                    this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                    break;
                }
                case INT: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asIntPointer();
                    this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                    break;
                }
                case SHORT: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asShortPointer();
                    this.indexer = ShortIndexer.create((ShortPointer)((ShortPointer)this.pointer));
                    break;
                }
                case UBYTE: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asBytePointer();
                    this.indexer = UByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                    break;
                }
                case BYTE: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asBytePointer();
                    this.indexer = ByteIndexer.create((BytePointer)((BytePointer)this.pointer));
                    break;
                }
                case BOOL: {
                    this.pointer = new CudaPointer(this.allocationPoint.getPointers().getHostPointer(), this.length).asBooleanPointer();
                    this.indexer = BooleanIndexer.create((BooleanPointer)((BooleanPointer)this.pointer));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported data type: " + this.type);
                }
            }
            this.readContent(s, t, t);
            this.allocationPoint.tickHostWrite();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AtomicAllocator.getInstance().getFlowController().synchronizeToDevice(this.allocationPoint);
    }

    public byte[] asBytes() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asBytes();
    }

    public double[] asDouble() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asDouble();
    }

    public float[] asFloat() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asFloat();
    }

    public int[] asInt() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asInt();
    }

    public ByteBuffer asNio() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNio();
    }

    public DoubleBuffer asNioDouble() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNioDouble();
    }

    public FloatBuffer asNioFloat() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNioFloat();
    }

    public IntBuffer asNioInt() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNioInt();
    }

    public DataBuffer dup() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        DataBuffer buffer = this.create(this.length);
        allocator.memcpyBlocking(buffer, new CudaPointer(allocator.getHostPointer(this).address()), this.length * (long)this.elementSize, 0L);
        return buffer;
    }

    public Number getNumber(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getNumber(i);
    }

    public double getDouble(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getDouble(i);
    }

    public long getLong(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getLong(i);
    }

    public float getFloat(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getFloat(i);
    }

    public int getInt(long ix) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getInt(ix);
    }

    public DataBuffer reallocate(long length) {
        Nd4j.getExecutioner().commit();
        AllocationPoint old = this.allocationPoint;
        this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(length, this.elementSize, this.dataType()), false);
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
        this.trackingPoint = this.allocationPoint.getObjectId();
        long oldLength = this.length;
        this.length = length;
        if (old.getHostPointer() != null) {
            this.lazyAllocateHostPointer();
        }
        CudaContext context = AtomicAllocator.getInstance().getDeviceContext();
        NativeOpsHolder.getInstance().getDeviceNativeOps().memsetAsync(this.allocationPoint.getDevicePointer(), 0, length * (long)this.elementSize, 0, (Pointer)context.getSpecialStream());
        MemcpyDirection direction = MemcpyDirection.DEVICE_TO_DEVICE;
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        if (old.isActualOnDeviceSide()) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().memcpyAsync(this.allocationPoint.getDevicePointer(), old.getDevicePointer(), oldLength * (long)this.elementSize, CudaConstants.cudaMemcpyDeviceToDevice, (Pointer)context.getSpecialStream());
        } else if (old.isActualOnHostSide()) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().memcpyAsync(this.allocationPoint.getDevicePointer(), old.getHostPointer(), oldLength * (long)this.elementSize, CudaConstants.cudaMemcpyHostToDevice, (Pointer)context.getSpecialStream());
            direction = MemcpyDirection.HOST_TO_DEVICE;
        }
        context.getSpecialStream().synchronize();
        PerformanceTracker.getInstance().helperRegisterTransaction(this.allocationPoint.getDeviceId(), perfD, this.allocationPoint.getNumberOfBytes(), direction);
        this.allocationPoint.tickDeviceWrite();
        if (!this.isAttached()) {
            AtomicAllocator.getInstance().freeMemory(old);
        }
        return this;
    }

    public long capacity() {
        if (this.allocationPoint.getHostPointer() != null) {
            return this.pointer.capacity();
        }
        return this.length;
    }

    protected void release() {
        if (!this.released) {
            AtomicAllocator.getInstance().freeMemory(this.allocationPoint);
            this.allocationPoint.setReleased(true);
        }
        this.released = true;
    }

    public String getUniqueId() {
        return "BCDB_" + this.allocationPoint.getObjectId();
    }

    public Deallocator deallocator() {
        return new CudaDeallocator(this);
    }

    public int targetDevice() {
        return AtomicAllocator.getInstance().getAllocationPoint(this).getDeviceId();
    }

    public AllocationPoint getAllocationPoint() {
        return this.allocationPoint;
    }
}

