/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.nd4j.linalg.util.ArrayUtil;

public class CudaDoubleDataBuffer
extends BaseCudaDataBuffer {
    public CudaDoubleDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaDoubleDataBuffer(Pointer pointer, Pointer specialPointer, Indexer indexer, long length) {
        super(pointer, specialPointer, indexer, length);
    }

    public CudaDoubleDataBuffer(long length) {
        super(length, 8);
    }

    public CudaDoubleDataBuffer(long length, boolean initialize) {
        super(length, 8, initialize);
    }

    public CudaDoubleDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, 8, initialize, workspace);
    }

    public CudaDoubleDataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaDoubleDataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    public CudaDoubleDataBuffer(double[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, 0L, workspace);
    }

    protected void initTypeAndSize() {
        this.type = DataType.DOUBLE;
        this.elementSize = (byte)8;
    }

    public CudaDoubleDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaDoubleDataBuffer(double[] data) {
        this(data.length);
        this.setData(data);
    }

    public CudaDoubleDataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaDoubleDataBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaDoubleDataBuffer(double[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        super(data, copy, offset, workspace);
    }

    public CudaDoubleDataBuffer(float[] data) {
        super(data);
    }

    public CudaDoubleDataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaDoubleDataBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaDoubleDataBuffer(int[] data) {
        super(data);
    }

    public CudaDoubleDataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaDoubleDataBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaDoubleDataBuffer(byte[] data, long length) {
        super(data, length, DataType.DOUBLE);
    }

    public CudaDoubleDataBuffer(ByteBuffer buffer, long length) {
        super(buffer, (long)((int)length), DataType.DOUBLE);
    }

    public CudaDoubleDataBuffer(ByteBuffer buffer, long length, long offset) {
        super(buffer, length, offset, DataType.DOUBLE);
    }

    protected DataBuffer create(long length) {
        return new CudaDoubleDataBuffer(length);
    }

    @Override
    public void setData(int[] data) {
        this.setData(ArrayUtil.toDoubles((int[])data));
    }

    @Override
    public void setData(float[] data) {
        this.setData(ArrayUtil.toDoubles((float[])data));
    }

    public DataBuffer create(double[] data) {
        return new CudaDoubleDataBuffer(data);
    }

    public DataBuffer create(float[] data) {
        return new CudaDoubleDataBuffer(data);
    }

    public DataBuffer create(int[] data) {
        return new CudaDoubleDataBuffer(data);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.getHostPointer() == null) {
            stream.writeInt(0);
        } else {
            double[] arr = this.asDouble();
            stream.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                stream.writeDouble(arr[i]);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int n = stream.readInt();
        double[] arr = new double[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = stream.readDouble();
        }
        this.length = n;
        this.elementSize = (byte)8;
        this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(this.length, this.elementSize, DataType.DOUBLE), false);
        this.trackingPoint = this.allocationPoint.getObjectId();
        this.setData(arr);
    }
}

