/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import lombok.NonNull;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.pointers.PointersPair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;

public class CudaLongDataBuffer
extends BaseCudaDataBuffer {
    public CudaLongDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaLongDataBuffer(Pointer pointer, Pointer specialPointer, Indexer indexer, long length) {
        super(pointer, specialPointer, indexer, length);
    }

    public CudaLongDataBuffer(@NonNull Pointer hostPointer, @NonNull Pointer devicePointer, long numberOfElements) {
        if (hostPointer == null) {
            throw new NullPointerException("hostPointer is marked @NonNull but is null");
        }
        if (devicePointer == null) {
            throw new NullPointerException("devicePointer is marked @NonNull but is null");
        }
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.offset = 0L;
        this.originalOffset = 0L;
        this.underlyingLength = numberOfElements;
        this.length = numberOfElements;
        this.initTypeAndSize();
        this.pointer = new CudaPointer(hostPointer, numberOfElements).asLongPointer();
        this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
        this.allocationPoint = AtomicAllocator.getInstance().pickExternalBuffer(this);
        PointersPair pp = new PointersPair(devicePointer, this.pointer);
        this.allocationPoint.setPointers(pp);
        this.trackingPoint = this.allocationPoint.getObjectId();
    }

    public CudaLongDataBuffer(long length) {
        super(length, 8);
    }

    public CudaLongDataBuffer(long length, boolean initialize) {
        super(length, 8, initialize);
    }

    public CudaLongDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, 8, initialize, workspace);
    }

    public CudaLongDataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaLongDataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    public CudaLongDataBuffer(double[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, 0L, workspace);
    }

    protected void initTypeAndSize() {
        this.type = DataType.LONG;
        this.elementSize = (byte)8;
    }

    public CudaLongDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaLongDataBuffer(double[] data) {
        this(data.length);
        this.setData(data);
    }

    public CudaLongDataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaLongDataBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaLongDataBuffer(double[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        super(data, copy, offset, workspace);
    }

    public CudaLongDataBuffer(float[] data) {
        super(data);
    }

    public CudaLongDataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaLongDataBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaLongDataBuffer(int[] data) {
        super(data);
    }

    public CudaLongDataBuffer(long[] data) {
        this(data, true);
    }

    public CudaLongDataBuffer(long[] data, boolean copy) {
        super(data.length, 8);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public CudaLongDataBuffer(long[] data, MemoryWorkspace workspace) {
        super((long)data.length, 8, workspace);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public CudaLongDataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaLongDataBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaLongDataBuffer(byte[] data, long length) {
        super(data, length, DataType.LONG);
    }

    public CudaLongDataBuffer(ByteBuffer buffer, long length) {
        super(buffer, (long)((int)length), DataType.LONG);
    }

    public CudaLongDataBuffer(ByteBuffer buffer, long length, long offset) {
        super(buffer, length, offset, DataType.LONG);
    }

    protected DataBuffer create(long length) {
        return new CudaLongDataBuffer(length);
    }

    public DataBuffer create(double[] data) {
        return new CudaLongDataBuffer(data);
    }

    public DataBuffer create(float[] data) {
        return new CudaLongDataBuffer(data);
    }

    public DataBuffer create(int[] data) {
        return new CudaLongDataBuffer(data);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.getHostPointer() == null) {
            stream.writeInt(0);
        } else {
            double[] arr = this.asDouble();
            stream.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                stream.writeDouble(arr[i]);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int n = stream.readInt();
        double[] arr = new double[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = stream.readDouble();
        }
        this.length = n;
        this.elementSize = (byte)8;
        this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(this.length, this.elementSize, DataType.LONG), false);
        this.trackingPoint = this.allocationPoint.getObjectId();
        this.setData(arr);
    }
}

