/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.context;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t;
import org.nd4j.jita.allocator.pointers.cuda.cudaStream_t;
import org.nd4j.jita.allocator.pointers.cuda.cusolverDnHandle_t;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;

public class CudaContext {
    private cudaStream_t oldStream;
    private cudaStream_t specialStream;
    private cublasHandle_t cublasHandle;
    private cusolverDnHandle_t solverHandle;
    private Pointer bufferReduction;
    private Pointer bufferAllocation;
    private Pointer bufferScalar;
    private Pointer bufferSpecial;
    private int deviceId = -1;
    private static final transient NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();

    public String toString() {
        return "CudaContext{bufferReduction=" + this.bufferReduction + ", bufferScalar=" + this.bufferScalar + ", deviceId=" + this.deviceId + '}';
    }

    public void syncOldStream() {
        if (nativeOps.streamSynchronize((Pointer)this.oldStream) == 0) {
            throw new ND4JIllegalStateException("CUDA stream synchronization failed");
        }
    }

    public void syncSpecialStream() {
        if (nativeOps.streamSynchronize((Pointer)this.specialStream) == 0) {
            throw new ND4JIllegalStateException("CUDA special stream synchronization failed");
        }
    }

    public Pointer getCublasStream() {
        PointerPointer lptr = new PointerPointer((Pointer)this.getOldStream());
        return lptr.get(0L);
    }

    public cublasHandle_t getCublasHandle() {
        PointerPointer lptr = new PointerPointer((Pointer)this.cublasHandle);
        return new cublasHandle_t(lptr.get(0L));
    }

    public cusolverDnHandle_t getSolverHandle() {
        PointerPointer lptr = new PointerPointer((Pointer)this.solverHandle);
        return new cusolverDnHandle_t(lptr.get(0L));
    }

    public static CudaContextBuilder builder() {
        return new CudaContextBuilder();
    }

    public cudaStream_t getOldStream() {
        return this.oldStream;
    }

    public cudaStream_t getSpecialStream() {
        return this.specialStream;
    }

    public Pointer getBufferReduction() {
        return this.bufferReduction;
    }

    public Pointer getBufferAllocation() {
        return this.bufferAllocation;
    }

    public Pointer getBufferScalar() {
        return this.bufferScalar;
    }

    public Pointer getBufferSpecial() {
        return this.bufferSpecial;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setOldStream(cudaStream_t oldStream) {
        this.oldStream = oldStream;
    }

    public void setSpecialStream(cudaStream_t specialStream) {
        this.specialStream = specialStream;
    }

    public void setCublasHandle(cublasHandle_t cublasHandle) {
        this.cublasHandle = cublasHandle;
    }

    public void setSolverHandle(cusolverDnHandle_t solverHandle) {
        this.solverHandle = solverHandle;
    }

    public void setBufferReduction(Pointer bufferReduction) {
        this.bufferReduction = bufferReduction;
    }

    public void setBufferAllocation(Pointer bufferAllocation) {
        this.bufferAllocation = bufferAllocation;
    }

    public void setBufferScalar(Pointer bufferScalar) {
        this.bufferScalar = bufferScalar;
    }

    public void setBufferSpecial(Pointer bufferSpecial) {
        this.bufferSpecial = bufferSpecial;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CudaContext)) {
            return false;
        }
        CudaContext other = (CudaContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        cudaStream_t this$oldStream = this.getOldStream();
        cudaStream_t other$oldStream = other.getOldStream();
        if (this$oldStream == null ? other$oldStream != null : !((Object)((Object)this$oldStream)).equals((Object)other$oldStream)) {
            return false;
        }
        cudaStream_t this$specialStream = this.getSpecialStream();
        cudaStream_t other$specialStream = other.getSpecialStream();
        if (this$specialStream == null ? other$specialStream != null : !((Object)((Object)this$specialStream)).equals((Object)other$specialStream)) {
            return false;
        }
        cublasHandle_t this$cublasHandle = this.getCublasHandle();
        cublasHandle_t other$cublasHandle = other.getCublasHandle();
        if (this$cublasHandle == null ? other$cublasHandle != null : !((Object)((Object)this$cublasHandle)).equals((Object)other$cublasHandle)) {
            return false;
        }
        cusolverDnHandle_t this$solverHandle = this.getSolverHandle();
        cusolverDnHandle_t other$solverHandle = other.getSolverHandle();
        if (this$solverHandle == null ? other$solverHandle != null : !((Object)((Object)this$solverHandle)).equals((Object)other$solverHandle)) {
            return false;
        }
        Pointer this$bufferReduction = this.getBufferReduction();
        Pointer other$bufferReduction = other.getBufferReduction();
        if (this$bufferReduction == null ? other$bufferReduction != null : !this$bufferReduction.equals(other$bufferReduction)) {
            return false;
        }
        Pointer this$bufferAllocation = this.getBufferAllocation();
        Pointer other$bufferAllocation = other.getBufferAllocation();
        if (this$bufferAllocation == null ? other$bufferAllocation != null : !this$bufferAllocation.equals(other$bufferAllocation)) {
            return false;
        }
        Pointer this$bufferScalar = this.getBufferScalar();
        Pointer other$bufferScalar = other.getBufferScalar();
        if (this$bufferScalar == null ? other$bufferScalar != null : !this$bufferScalar.equals(other$bufferScalar)) {
            return false;
        }
        Pointer this$bufferSpecial = this.getBufferSpecial();
        Pointer other$bufferSpecial = other.getBufferSpecial();
        if (this$bufferSpecial == null ? other$bufferSpecial != null : !this$bufferSpecial.equals(other$bufferSpecial)) {
            return false;
        }
        return this.getDeviceId() == other.getDeviceId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CudaContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        cudaStream_t $oldStream = this.getOldStream();
        result = result * 59 + ($oldStream == null ? 43 : ((Object)((Object)$oldStream)).hashCode());
        cudaStream_t $specialStream = this.getSpecialStream();
        result = result * 59 + ($specialStream == null ? 43 : ((Object)((Object)$specialStream)).hashCode());
        cublasHandle_t $cublasHandle = this.getCublasHandle();
        result = result * 59 + ($cublasHandle == null ? 43 : ((Object)((Object)$cublasHandle)).hashCode());
        cusolverDnHandle_t $solverHandle = this.getSolverHandle();
        result = result * 59 + ($solverHandle == null ? 43 : ((Object)((Object)$solverHandle)).hashCode());
        Pointer $bufferReduction = this.getBufferReduction();
        result = result * 59 + ($bufferReduction == null ? 43 : $bufferReduction.hashCode());
        Pointer $bufferAllocation = this.getBufferAllocation();
        result = result * 59 + ($bufferAllocation == null ? 43 : $bufferAllocation.hashCode());
        Pointer $bufferScalar = this.getBufferScalar();
        result = result * 59 + ($bufferScalar == null ? 43 : $bufferScalar.hashCode());
        Pointer $bufferSpecial = this.getBufferSpecial();
        result = result * 59 + ($bufferSpecial == null ? 43 : $bufferSpecial.hashCode());
        result = result * 59 + this.getDeviceId();
        return result;
    }

    public CudaContext(cudaStream_t oldStream, cudaStream_t specialStream, cublasHandle_t cublasHandle, cusolverDnHandle_t solverHandle, Pointer bufferReduction, Pointer bufferAllocation, Pointer bufferScalar, Pointer bufferSpecial, int deviceId) {
        this.oldStream = oldStream;
        this.specialStream = specialStream;
        this.cublasHandle = cublasHandle;
        this.solverHandle = solverHandle;
        this.bufferReduction = bufferReduction;
        this.bufferAllocation = bufferAllocation;
        this.bufferScalar = bufferScalar;
        this.bufferSpecial = bufferSpecial;
        this.deviceId = deviceId;
    }

    public CudaContext() {
    }

    public static class CudaContextBuilder {
        private cudaStream_t oldStream;
        private cudaStream_t specialStream;
        private cublasHandle_t cublasHandle;
        private cusolverDnHandle_t solverHandle;
        private Pointer bufferReduction;
        private Pointer bufferAllocation;
        private Pointer bufferScalar;
        private Pointer bufferSpecial;
        private int deviceId;

        CudaContextBuilder() {
        }

        public CudaContextBuilder oldStream(cudaStream_t oldStream) {
            this.oldStream = oldStream;
            return this;
        }

        public CudaContextBuilder specialStream(cudaStream_t specialStream) {
            this.specialStream = specialStream;
            return this;
        }

        public CudaContextBuilder cublasHandle(cublasHandle_t cublasHandle) {
            this.cublasHandle = cublasHandle;
            return this;
        }

        public CudaContextBuilder solverHandle(cusolverDnHandle_t solverHandle) {
            this.solverHandle = solverHandle;
            return this;
        }

        public CudaContextBuilder bufferReduction(Pointer bufferReduction) {
            this.bufferReduction = bufferReduction;
            return this;
        }

        public CudaContextBuilder bufferAllocation(Pointer bufferAllocation) {
            this.bufferAllocation = bufferAllocation;
            return this;
        }

        public CudaContextBuilder bufferScalar(Pointer bufferScalar) {
            this.bufferScalar = bufferScalar;
            return this;
        }

        public CudaContextBuilder bufferSpecial(Pointer bufferSpecial) {
            this.bufferSpecial = bufferSpecial;
            return this;
        }

        public CudaContextBuilder deviceId(int deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public CudaContext build() {
            return new CudaContext(this.oldStream, this.specialStream, this.cublasHandle, this.solverHandle, this.bufferReduction, this.bufferAllocation, this.bufferScalar, this.bufferSpecial, this.deviceId);
        }

        public String toString() {
            return "CudaContext.CudaContextBuilder(oldStream=" + (Object)((Object)this.oldStream) + ", specialStream=" + (Object)((Object)this.specialStream) + ", cublasHandle=" + (Object)((Object)this.cublasHandle) + ", solverHandle=" + (Object)((Object)this.solverHandle) + ", bufferReduction=" + this.bufferReduction + ", bufferAllocation=" + this.bufferAllocation + ", bufferScalar=" + this.bufferScalar + ", bufferSpecial=" + this.bufferSpecial + ", deviceId=" + this.deviceId + ")";
        }
    }
}

