/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.ops.executioner;

import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cudaStream_t;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOpContext;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueContext;
import org.nd4j.nativeblas.OpaqueRandomGenerator;

public class CudaOpContext
extends BaseOpContext
implements OpContext {
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private OpaqueContext context = this.nativeOps.createGraphContext(1);

    public void close() {
        this.nativeOps.deleteGraphContext(this.context);
    }

    public void setIArguments(long ... arguments) {
        if (arguments.length > 0) {
            super.setIArguments(arguments);
            this.nativeOps.setGraphContextIArguments(this.context, new LongPointer(arguments), arguments.length);
        }
    }

    public void setBArguments(boolean ... arguments) {
        if (arguments.length > 0) {
            super.setBArguments(arguments);
            this.nativeOps.setGraphContextBArguments(this.context, new BooleanPointer(arguments), arguments.length);
        }
    }

    public void setTArguments(double ... arguments) {
        if (arguments.length > 0) {
            super.setTArguments(arguments);
            this.nativeOps.setGraphContextTArguments(this.context, new DoublePointer(arguments), arguments.length);
        }
    }

    public void setRngStates(long rootState, long nodeState) {
        this.nativeOps.setRandomGeneratorStates(this.nativeOps.getGraphContextRandomGenerator(this.context), rootState, nodeState);
    }

    public Pair<Long, Long> getRngStates() {
        OpaqueRandomGenerator g = this.nativeOps.getGraphContextRandomGenerator(this.context);
        return Pair.makePair((Object)this.nativeOps.getRandomGeneratorRootState(g), (Object)this.nativeOps.getRandomGeneratorNodeState(g));
    }

    public void setInputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        CudaContext ctx = AtomicAllocator.getInstance().getFlowController().prepareAction(null, array);
        this.nativeOps.setGraphContextInputArray(this.context, index, array.isEmpty() ? null : array.data().addressPointer(), array.shapeInfoDataBuffer().addressPointer(), array.isEmpty() ? null : AtomicAllocator.getInstance().getPointer(array, ctx), AtomicAllocator.getInstance().getPointer(array.shapeInfoDataBuffer()));
        super.setInputArray(index, array);
    }

    public void setOutputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        CudaContext ctx = AtomicAllocator.getInstance().getFlowController().prepareAction(array, null);
        this.nativeOps.setGraphContextOutputArray(this.context, index, array.isEmpty() ? null : array.data().addressPointer(), array.shapeInfoDataBuffer().addressPointer(), array.isEmpty() ? null : AtomicAllocator.getInstance().getPointer(array, ctx), AtomicAllocator.getInstance().getPointer(array.shapeInfoDataBuffer()));
        super.setOutputArray(index, array);
    }

    public Pointer contextPointer() {
        for (INDArray v : this.fastpath_in.values()) {
            if (v.isEmpty() || v.isS()) continue;
            AtomicAllocator.getInstance().getAllocationPoint(v).tickHostRead();
            AtomicAllocator.getInstance().getAllocationPoint(v).tickDeviceRead();
        }
        for (INDArray v : this.fastpath_out.values()) {
            if (v.isEmpty() || v.isS()) continue;
            AtomicAllocator.getInstance().getAllocationPoint(v).tickHostRead();
            AtomicAllocator.getInstance().getAllocationPoint(v).tickDeviceRead();
        }
        return this.context;
    }

    public void setCudaStream(cudaStream_t stream, Pointer reductionPointer, Pointer allocationPointer) {
        this.nativeOps.setGraphContextCudaContext(this.context, (Pointer)stream, reductionPointer, allocationPointer);
    }

    public void markInplace(boolean reallyInplace) {
        this.nativeOps.markGraphContextInplace(this.context, reallyInplace);
    }

    public void allowHelpers(boolean reallyAllow) {
        this.nativeOps.ctxAllowHelpers(this.context, reallyAllow);
    }
}

