/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.serde.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.guava.primitives.Longs;

public class GsonDeserializationUtils {
    private static final JsonParser JSON_PARSER = new JsonParser();

    public static INDArray deserializeRawJson(String serializedRawArray) {
        String cleanedRawArray = serializedRawArray;
        JsonArray jsonArray = JSON_PARSER.parse(cleanedRawArray).getAsJsonArray();
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        dimensions.add(jsonArray.size());
        GsonDeserializationUtils.getSizeMultiDimensionalArray(jsonArray, dimensions);
        return GsonDeserializationUtils.buildArray(dimensions, cleanedRawArray);
    }

    private static void getSizeMultiDimensionalArray(JsonArray jsonArray, List<Integer> dimensions) {
        JsonElement jsonElement;
        Iterator iterator = jsonArray.iterator();
        if (iterator.hasNext() && (jsonElement = (JsonElement)iterator.next()).isJsonArray()) {
            JsonArray shapeArray = jsonElement.getAsJsonArray();
            dimensions.add(shapeArray.size());
            GsonDeserializationUtils.getSizeMultiDimensionalArray(shapeArray, dimensions);
        }
    }

    private static boolean isArrayWithSingleRow(List<Integer> dimensions) {
        return dimensions.size() == 1;
    }

    private static INDArray buildArray(List<Integer> dimensions, String rawArray) {
        long[] shape = Longs.toArray(dimensions);
        String[] entries = StringUtils.replacePattern((String)rawArray, (String)"[\\[\\]\\n]", (String)"").split(",");
        double[] entryValues = new double[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            entryValues[i] = Double.parseDouble(entries[i]);
        }
        return Nd4j.create((double[])entryValues, (long[])shape, (DataType)Nd4j.defaultFloatingPointType());
    }

    static {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
    }
}

