/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.compression.impl;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.compression.impl.AbstractCompressor;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.nd4j.linalg.factory.Nd4j;

public class NoOp
extends AbstractCompressor {
    public String getDescriptor() {
        return "NOOP";
    }

    public CompressionType getCompressionType() {
        return CompressionType.LOSSLESS;
    }

    @Override
    public DataBuffer decompress(DataBuffer buffer) {
        CompressedDataBuffer comp = (CompressedDataBuffer)buffer;
        DataBuffer result = Nd4j.createBuffer((long)comp.length(), (boolean)false);
        Nd4j.getMemoryManager().memcpy(result, buffer);
        return result;
    }

    @Override
    public DataBuffer compress(DataBuffer buffer) {
        CompressionDescriptor descriptor = new CompressionDescriptor(buffer, (NDArrayCompressor)this);
        BytePointer ptr = new BytePointer(buffer.length() * (long)buffer.getElementSize());
        CompressedDataBuffer result = new CompressedDataBuffer((Pointer)ptr, descriptor);
        Nd4j.getMemoryManager().memcpy((DataBuffer)result, buffer);
        return result;
    }

    @Override
    protected CompressedDataBuffer compressPointer(DataBuffer.TypeEx srcType, Pointer srcPointer, int length, int elementSize) {
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.setCompressionType(this.getCompressionType());
        descriptor.setOriginalLength((long)(length * elementSize));
        descriptor.setCompressionAlgorithm(this.getDescriptor());
        descriptor.setOriginalElementSize((long)elementSize);
        descriptor.setCompressedLength((long)(length * elementSize));
        descriptor.setNumberOfElements((long)length);
        BytePointer ptr = new BytePointer((long)(length * elementSize));
        Pointer.memcpy((Pointer)ptr, (Pointer)srcPointer, (long)(length * elementSize));
        CompressedDataBuffer buffer = new CompressedDataBuffer((Pointer)ptr, descriptor);
        return buffer;
    }
}

