/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.compression.impl;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.DataTypeEx;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompressor
implements NDArrayCompressor {
    private static final Logger log = LoggerFactory.getLogger(AbstractCompressor.class);

    public INDArray compress(INDArray array) {
        INDArray dup = array.dup(array.ordering());
        Nd4j.getExecutioner().commit();
        dup.setData(this.compress(dup.data()));
        dup.markAsCompressed(true);
        return dup;
    }

    public void configure(Object ... vars) {
    }

    public void compressi(INDArray array) {
        if (array.isView()) {
            throw new UnsupportedOperationException("Impossible to apply inplace compression on View");
        }
        array.setData(this.compress(array.data()));
        array.markAsCompressed(true);
    }

    public void decompressi(INDArray array) {
        if (!array.isCompressed()) {
            return;
        }
        array.markAsCompressed(false);
        array.setData(this.decompress(array.data(), ((CompressedDataBuffer)array.data()).getCompressionDescriptor().getOriginalDataType()));
    }

    public INDArray decompress(INDArray array) {
        if (!array.isCompressed()) {
            return array;
        }
        CompressionDescriptor descriptor = ((CompressedDataBuffer)array.data()).getCompressionDescriptor();
        DataBuffer buffer = this.decompress(array.data(), descriptor.getOriginalDataType());
        DataBuffer shapeInfo = array.shapeInfoDataBuffer();
        INDArray rest = Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (DataBuffer)shapeInfo);
        return rest;
    }

    public abstract DataBuffer decompress(DataBuffer var1, DataType var2);

    public abstract DataBuffer compress(DataBuffer var1);

    protected static DataTypeEx convertType(DataType type) {
        if (type == DataType.HALF) {
            return DataTypeEx.FLOAT16;
        }
        if (type == DataType.FLOAT) {
            return DataTypeEx.FLOAT;
        }
        if (type == DataType.DOUBLE) {
            return DataTypeEx.DOUBLE;
        }
        throw new IllegalStateException("Unknown dataType: [" + type + "]");
    }

    protected DataTypeEx getGlobalTypeEx() {
        DataType type = Nd4j.dataType();
        return AbstractCompressor.convertType(type);
    }

    public static DataTypeEx getBufferTypeEx(DataBuffer buffer) {
        DataType type = buffer.dataType();
        return AbstractCompressor.convertType(type);
    }

    public INDArray compress(float[] data) {
        return this.compress(data, new int[]{1, data.length}, Nd4j.order().charValue());
    }

    public INDArray compress(double[] data) {
        return this.compress(data, new int[]{1, data.length}, Nd4j.order().charValue());
    }

    public INDArray compress(float[] data, int[] shape, char order) {
        FloatPointer pointer = new FloatPointer(data);
        DataBuffer shapeInfo = (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), order, DataType.FLOAT).getFirst();
        CompressedDataBuffer buffer = this.compressPointer(DataTypeEx.FLOAT, (Pointer)pointer, data.length, 4);
        return Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (DataBuffer)shapeInfo);
    }

    public INDArray compress(double[] data, int[] shape, char order) {
        DoublePointer pointer = new DoublePointer(data);
        DataBuffer shapeInfo = (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), order, DataType.DOUBLE).getFirst();
        CompressedDataBuffer buffer = this.compressPointer(DataTypeEx.DOUBLE, (Pointer)pointer, data.length, 8);
        return Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (DataBuffer)shapeInfo);
    }

    protected abstract CompressedDataBuffer compressPointer(DataTypeEx var1, Pointer var2, int var3, int var4);
}

