/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.compression;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.DataTypeEx;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.cpu.nativecpu.compression.CpuThreshold;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class CpuFlexibleThreshold
extends CpuThreshold {
    public CpuFlexibleThreshold() {
        this.threshold = 0.1f;
    }

    @Override
    public String getDescriptor() {
        return "FTHRESHOLD";
    }

    @Override
    public void configure(Object ... vars) {
        super.configure(vars);
    }

    @Override
    public DataBuffer compress(DataBuffer buffer) {
        INDArray temp = Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (DataBuffer)((DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new long[]{1L, buffer.length()}, DataType.INT).getFirst()));
        double max = temp.amaxNumber().doubleValue();
        int cntAbs = temp.scan(Conditions.absGreaterThanOrEqual((Number)(max - max * (double)this.threshold))).intValue();
        long originalLength = buffer.length() * (long)Nd4j.sizeOfDataType((DataType)buffer.dataType());
        int compressedLength = cntAbs + 4;
        IntPointer pointer = new IntPointer((long)compressedLength);
        pointer.put(0L, cntAbs);
        pointer.put(1L, (int)buffer.length());
        pointer.put(2L, Float.floatToIntBits(this.threshold));
        pointer.put(3L, 0);
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.setCompressedLength((long)(compressedLength * 4));
        descriptor.setOriginalLength(originalLength);
        descriptor.setOriginalElementSize((long)Nd4j.sizeOfDataType((DataType)buffer.dataType()));
        descriptor.setNumberOfElements(buffer.length());
        descriptor.setCompressionAlgorithm(this.getDescriptor());
        descriptor.setCompressionType(this.getCompressionType());
        CompressedDataBuffer cbuff = new CompressedDataBuffer((Pointer)pointer, descriptor);
        Nd4j.getNDArrayFactory().convertDataEx(CpuFlexibleThreshold.getBufferTypeEx((DataBuffer)buffer), buffer.addressPointer(), DataTypeEx.FTHRESHOLD, (Pointer)pointer, buffer.length());
        Nd4j.getAffinityManager().tagLocation(buffer, AffinityManager.Location.HOST);
        return cbuff;
    }
}

