/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.LongBuffer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.compression.CompressionUtils;
import org.nd4j.linalg.cpu.nativecpu.NDArray;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuBlas;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLapack;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel1;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel2;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel3;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.nativeblas.BaseNativeNDArrayFactory;
import org.nd4j.nativeblas.LongPointerWrapper;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuNDArrayFactory
extends BaseNativeNDArrayFactory {
    private static final Logger log = LoggerFactory.getLogger(CpuNDArrayFactory.class);
    protected ThreadLocal<PointerPointer> extrazA = new ThreadLocal();
    protected ThreadLocal<PointerPointer> extrazB = new ThreadLocal();
    protected ThreadLocal<Integer> extrazSize = new ThreadLocal();

    public CpuNDArrayFactory() {
    }

    public CpuNDArrayFactory(DataBuffer.Type dtype, Character order) {
        super(dtype, order);
    }

    public CpuNDArrayFactory(DataBuffer.Type dtype, char order) {
        super(dtype, order);
    }

    public void createBlas() {
        String lib = System.getProperty("org.bytedeco.javacpp.openblas.load", System.getProperty("org.bytedeco.javacpp.openblas_nolapack.load", "")).toLowerCase();
        if (lib.trim().length() == 0) {
            System.setProperty("org.bytedeco.javacpp.openblas_nolapack.load", "mklml");
        }
        this.blas = new CpuBlas();
        PointerPointer functions = new PointerPointer(10L);
        functions.put(0L, Loader.addressof((String)"cblas_sgemv"));
        functions.put(1L, Loader.addressof((String)"cblas_dgemv"));
        functions.put(2L, Loader.addressof((String)"cblas_sgemm"));
        functions.put(3L, Loader.addressof((String)"cblas_dgemm"));
        functions.put(4L, Loader.addressof((String)"cblas_sgemm_batch"));
        functions.put(5L, Loader.addressof((String)"cblas_dgemm_batch"));
        functions.put(6L, Loader.addressof((String)"LAPACKE_sgesvd"));
        functions.put(7L, Loader.addressof((String)"LAPACKE_dgesvd"));
        functions.put(8L, Loader.addressof((String)"LAPACKE_sgesdd"));
        functions.put(9L, Loader.addressof((String)"LAPACKE_dgesdd"));
        this.nativeOps.initializeFunctions(functions);
    }

    public void createLevel1() {
        this.level1 = new CpuLevel1();
    }

    public void createLevel2() {
        this.level2 = new CpuLevel2();
    }

    public void createLevel3() {
        this.level3 = new CpuLevel3();
    }

    public void createLapack() {
        this.lapack = new CpuLapack();
    }

    public INDArray create(int[] shape, DataBuffer buffer) {
        return new NDArray(shape, buffer);
    }

    public INDArray create(double[][] data) {
        return new NDArray(data);
    }

    public INDArray create(double[][] data, char ordering) {
        return new NDArray(data, ordering);
    }

    public INDArray create(DataBuffer data) {
        return new NDArray(data);
    }

    public INDArray create(DataBuffer data, long rows, long columns, int[] stride, long offset) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset);
    }

    public INDArray create(long rows, long columns, long[] stride, long offset) {
        return this.create(new long[]{rows, columns}, stride, offset);
    }

    public INDArray create(int[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((int[])shape, (char)ordering), 0L, ordering);
    }

    public INDArray create(long[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering);
    }

    public INDArray createUninitialized(int[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((int[])shape, (char)ordering), 0L, ordering, false);
    }

    public INDArray createUninitialized(long[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering, false);
    }

    public INDArray createUninitializedDetached(int[] shape, char ordering) {
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        Nd4j.getMemoryManager().setCurrentWorkspace(null);
        NDArray ret = new NDArray(shape, Nd4j.getStrides((int[])shape, (char)ordering), 0L, ordering, false);
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return ret;
    }

    public INDArray createUninitializedDetached(long[] shape, char ordering) {
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        Nd4j.getMemoryManager().setCurrentWorkspace(null);
        NDArray ret = new NDArray(shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering, false);
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return ret;
    }

    public INDArray create(DataBuffer data, int[] newShape, int[] newStride, long offset, char ordering) {
        return new NDArray(data, newShape, newStride, offset, ordering);
    }

    public INDArray create(float[] data, int[] shape, long offset, Character order) {
        return new NDArray(data, shape, offset, order.charValue());
    }

    public INDArray create(float[] data, long[] shape, long offset, Character order) {
        return new NDArray(data, shape, offset, order.charValue());
    }

    public INDArray create(float[] data, long rows, long columns, int[] stride, long offset, char ordering) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset, ordering);
    }

    public INDArray create(double[] data, int[] shape, char ordering) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, ordering);
    }

    public INDArray create(double[] data, long[] shape, char ordering) {
        return this.create(data, shape, Character.valueOf(ordering).charValue());
    }

    public INDArray create(float[] data, long[] shape, char ordering) {
        return this.create(data, shape, Character.valueOf(ordering).charValue());
    }

    public INDArray create(List<INDArray> list, int[] shape, char ordering) {
        return new NDArray(list, shape, ordering);
    }

    public INDArray create(List<INDArray> list, long[] shape, char ordering) {
        return new NDArray(list, shape, ordering);
    }

    public INDArray create(double[] data, int[] shape, long offset) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, offset);
    }

    public INDArray create(double[] data, long[] shape, long offset, Character order) {
        return new NDArray(data, shape, offset, order.charValue());
    }

    public INDArray create(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, stride, offset, ordering);
    }

    public INDArray create(double[] data, long[] shape, long[] stride, long offset, char ordering) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, stride, offset, ordering);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, long offset, char ordering) {
        return new NDArray(Nd4j.createBuffer((float[])data), shape, stride, offset, ordering);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, long offset) {
        return new NDArray(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(double[] data, long[] shape, long[] stride, long offset) {
        return new NDArray(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(DataBuffer data, long[] shape) {
        return new NDArray(data, shape);
    }

    public INDArray create(DataBuffer data, long[] shape, long[] stride, long offset) {
        return this.create(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(DataBuffer data, long[] shape, long[] stride, long offset, char ordering) {
        return new NDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, char order, long offset) {
        return new NDArray(data, shape, stride, offset, order);
    }

    public INDArray create(float[] data, int[] shape, int[] stride, long offset) {
        return new NDArray(data, shape, stride, offset);
    }

    public INDArray create(double[] data, int[] shape, int[] stride, long offset) {
        return new NDArray(data, shape, stride, offset);
    }

    public INDArray create(DataBuffer data, int[] shape) {
        return new NDArray(data, shape);
    }

    public INDArray create(DataBuffer data, int[] shape, int[] stride, long offset) {
        return new NDArray(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(List<INDArray> list, int[] shape) {
        return new NDArray(list, shape, Nd4j.getStrides((int[])shape));
    }

    public INDArray create(List<INDArray> list, long[] shape) {
        return new NDArray(list, shape, Nd4j.getStrides((long[])shape));
    }

    public INDArray empty(DataBuffer.Type type) {
        long extras = ArrayOptionsHelper.setOptionBit((long)0L, (ArrayType)ArrayType.EMPTY);
        extras = ArrayOptionsHelper.setOptionBit((long)extras, (DataBuffer.Type)type);
        Pair shape = Nd4j.getShapeInfoProvider().createShapeInformation(new int[0], new int[0], 0L, 1, 'c', extras);
        return new NDArray(null, (LongBuffer)shape.getFirst(), (long[])shape.getSecond());
    }

    public INDArray create(float[][] floats) {
        return new NDArray(floats);
    }

    public INDArray create(float[][] data, char ordering) {
        return new NDArray(data, ordering);
    }

    public INDArray create(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        return new NDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(DataBuffer buffer, int[] shape, long offset) {
        return new NDArray(buffer, shape, Nd4j.getStrides((int[])shape), offset);
    }

    public INDArray create(float[] data, int[] shape, long offset) {
        return new NDArray(data, shape, offset);
    }

    public INDArray toFlattened(char order, Collection<INDArray> matrices) {
        int length = 0;
        for (INDArray m : matrices) {
            length = (int)((long)length + m.length());
        }
        INDArray ret = Nd4j.create((int[])new int[]{1, length}, (char)order);
        int linearIndex = 0;
        PointerPointer dummy = new PointerPointer(new Pointer[]{null});
        for (INDArray m : matrices) {
            Nd4j.getCompressor().autoDecompress(m);
            if (m.ordering() == order && m.data().allocationMode() == DataBuffer.AllocationMode.HEAP && Shape.strideDescendingCAscendingF((INDArray)m) && Shape.isContiguousInBuffer((INDArray)m)) {
                Object[] retData;
                Object[] mData;
                int retFrom = linearIndex;
                long mFrom = m.offset();
                Object arr = m.data().array();
                if (arr instanceof float[]) {
                    mData = (float[])arr;
                    retData = (float[])ret.data().array();
                    System.arraycopy(mData, (int)mFrom, retData, retFrom, (int)m.length());
                } else {
                    mData = (double[])arr;
                    retData = (double[])ret.data().array();
                    System.arraycopy(mData, (int)mFrom, retData, retFrom, (int)m.length());
                }
                linearIndex = (int)((long)linearIndex + m.length());
                continue;
            }
            if (m.data().dataType() == DataBuffer.Type.DOUBLE) {
                this.nativeOps.flattenDouble(dummy, linearIndex, order, (DoublePointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), (DoublePointer)m.data().addressPointer(), (LongPointer)m.shapeInfoDataBuffer().addressPointer());
            } else if (m.data().dataType() == DataBuffer.Type.FLOAT) {
                this.nativeOps.flattenFloat(dummy, linearIndex, order, (FloatPointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), (FloatPointer)m.data().addressPointer(), (LongPointer)m.shapeInfoDataBuffer().addressPointer());
            } else {
                throw new UnsupportedOperationException("Illegal data opType for copy");
            }
            linearIndex = (int)((long)linearIndex + m.length());
        }
        return ret;
    }

    public INDArray[] tear(INDArray tensor, int ... dimensions) {
        if (tensor.isCompressed()) {
            Nd4j.getCompressor().decompressi(tensor);
        }
        Arrays.sort(dimensions);
        Pair tadBuffers = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(tensor, dimensions);
        long tadLength = 1L;
        long[] shape = new long[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            tadLength *= tensor.shape()[dimensions[i]];
            shape[i] = tensor.shape()[dimensions[i]];
        }
        int numTads = (int)(tensor.lengthLong() / tadLength);
        INDArray[] result = new INDArray[numTads];
        PointerPointer targets = new PointerPointer((long)numTads);
        for (int x = 0; x < numTads; ++x) {
            result[x] = Nd4j.createUninitialized((long[])shape);
            targets.put((long)x, result[x].data().pointer());
        }
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.tearDouble(null, (DoublePointer)tensor.data().pointer(), (LongPointer)tensor.shapeInfoDataBuffer().pointer(), targets, (LongPointer)result[0].shapeInfoDataBuffer().pointer(), (LongPointer)((DataBuffer)tadBuffers.getFirst()).pointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).pointer()));
        } else if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.nativeOps.tearFloat(null, (FloatPointer)tensor.data().pointer(), (LongPointer)tensor.shapeInfoDataBuffer().pointer(), targets, (LongPointer)result[0].shapeInfoDataBuffer().pointer(), (LongPointer)((DataBuffer)tadBuffers.getFirst()).pointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).pointer()));
        } else if (Nd4j.dataType() == DataBuffer.Type.HALF) {
            throw new UnsupportedOperationException("Half precision isn't supported for CPU backend");
        }
        return result;
    }

    public INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat == null || toConcat.length == 0) {
            throw new ND4JIllegalStateException("Can't concatenate 0 arrays");
        }
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        if (this.extrazA.get() == null || this.extrazB.get() == null || this.extrazSize.get() == null || this.extrazSize.get() < toConcat.length) {
            this.extrazA.set(new PointerPointer((long)toConcat.length));
            this.extrazB.set(new PointerPointer((long)toConcat.length));
            this.extrazSize.set(toConcat.length);
        }
        PointerPointer shapeInfoPointers = this.extrazA.get();
        PointerPointer dataPointers = this.extrazB.get();
        int sumAlongDim = 0;
        long[] outputShape = ArrayUtil.copy((long[])toConcat[0].shape());
        for (int i = 0; i < toConcat.length; ++i) {
            if (toConcat[i].isCompressed()) {
                Nd4j.getCompressor().decompressi(toConcat[i]);
            }
            shapeInfoPointers.put((long)i, toConcat[i].shapeInfoDataBuffer().addressPointer());
            dataPointers.put((long)i, toConcat[i].data().addressPointer());
            sumAlongDim = (int)((long)sumAlongDim + toConcat[i].size(dimension));
            for (int j = 0; j < toConcat[i].rank(); ++j) {
                if (j == dimension || toConcat[i].size(j) == outputShape[j]) continue;
                throw new IllegalArgumentException("Illegal concatenation at array " + i + " and shape element " + j);
            }
        }
        outputShape[dimension] = sumAlongDim;
        INDArray ret = Nd4j.createUninitialized((long[])outputShape, (char)Nd4j.order().charValue());
        if (ret.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.concatDouble(null, dimension, toConcat.length, dataPointers, shapeInfoPointers, (DoublePointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
        } else if (ret.data().dataType() == DataBuffer.Type.FLOAT) {
            this.nativeOps.concatFloat(null, dimension, toConcat.length, dataPointers, shapeInfoPointers, (FloatPointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
        } else if (ret.data().dataType() == DataBuffer.Type.HALF) {
            this.nativeOps.concatHalf(null, dimension, toConcat.length, dataPointers, shapeInfoPointers, (ShortPointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
        } else {
            throw new ND4JIllegalStateException("Unknown dataType: " + ret.data().dataType());
        }
        return ret;
    }

    public INDArray specialConcat(int dimension, INDArray ... toConcat) {
        return this.concat(dimension, toConcat);
    }

    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        return this.pullRows(source, sourceDimension, ArrayUtil.toLongArray((int[])indexes));
    }

    public INDArray pullRows(INDArray source, int sourceDimension, long[] indexes) {
        return this.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    public INDArray pullRows(INDArray source, int sourceDimension, long[] indexes, char order) {
        long[] shape;
        if (indexes == null || indexes.length < 1) {
            throw new IllegalStateException("Indexes can't be null or zero-length");
        }
        if (sourceDimension == 1) {
            shape = new long[]{indexes.length, source.shape()[sourceDimension]};
        } else if (sourceDimension == 0) {
            shape = new long[]{source.shape()[sourceDimension], indexes.length};
        } else {
            throw new UnsupportedOperationException("2D input is expected");
        }
        return this.pullRows(source, Nd4j.createUninitialized((long[])shape, (char)order), sourceDimension, indexes);
    }

    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order) {
        return this.pullRows(source, sourceDimension, ArrayUtil.toLongArray((int[])indexes), order);
    }

    public INDArray pullRows(INDArray source, INDArray destination, int sourceDimension, int[] indexes) {
        return this.pullRows(source, destination, sourceDimension, ArrayUtil.toLongArray((int[])indexes));
    }

    public INDArray pullRows(INDArray source, INDArray destination, int sourceDimension, long[] indexes) {
        Pointer zTadOffsets;
        if (indexes == null || indexes.length < 1) {
            throw new IllegalStateException("Indexes can't be null or zero-length");
        }
        long[] shape = null;
        if (sourceDimension == 1) {
            shape = new long[]{indexes.length, source.shape()[sourceDimension]};
        } else if (sourceDimension == 0) {
            shape = new long[]{source.shape()[sourceDimension], indexes.length};
        } else {
            throw new UnsupportedOperationException("2D input is expected");
        }
        INDArray ret = destination;
        if (ret == null) {
            ret = Nd4j.createUninitialized((long[])shape, (char)this.order);
        } else if (!Arrays.equals(shape, destination.shape())) {
            throw new IllegalStateException("Cannot pull rows into destination array: expected destination array of shape " + Arrays.toString(shape) + " but got destination array of shape " + Arrays.toString(destination.shape()));
        }
        Nd4j.getCompressor().autoDecompress(source);
        PointerPointer dummy = new PointerPointer(new Pointer[]{null});
        TADManager tadManager = Nd4j.getExecutioner().getTADManager();
        Pair tadBuffers = tadManager.getTADOnlyShapeInfo(source, new int[]{sourceDimension});
        Pair zTadBuffers = tadManager.getTADOnlyShapeInfo(ret, new int[]{sourceDimension});
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer zTadShapeInfo = ((DataBuffer)zTadBuffers.getFirst()).addressPointer();
        LongPointer pIndex = new LongPointer(indexes);
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        DataBuffer zOffsets = (DataBuffer)zTadBuffers.getSecond();
        Pointer pointer = zTadOffsets = zOffsets == null ? null : zOffsets.addressPointer();
        if (ret.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.pullRowsDouble(dummy, (DoublePointer)source.data().addressPointer(), (LongPointer)source.shapeInfoDataBuffer().addressPointer(), (DoublePointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), (long)indexes.length, pIndex, (LongPointer)hostTadShapeInfo, (LongPointer)new LongPointerWrapper(hostTadOffsets), (LongPointer)zTadShapeInfo, (LongPointer)new LongPointerWrapper(zTadOffsets));
        } else if (ret.data().dataType() == DataBuffer.Type.FLOAT) {
            this.nativeOps.pullRowsFloat(dummy, (FloatPointer)source.data().addressPointer(), (LongPointer)source.shapeInfoDataBuffer().addressPointer(), (FloatPointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), (long)indexes.length, pIndex, (LongPointer)hostTadShapeInfo, (LongPointer)new LongPointerWrapper(hostTadOffsets), (LongPointer)zTadShapeInfo, (LongPointer)new LongPointerWrapper(zTadOffsets));
        } else {
            this.nativeOps.pullRowsHalf(dummy, (ShortPointer)source.data().addressPointer(), (LongPointer)source.shapeInfoDataBuffer().addressPointer(), (ShortPointer)ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), (long)indexes.length, pIndex, (LongPointer)hostTadShapeInfo, (LongPointer)new LongPointerWrapper(hostTadOffsets), (LongPointer)zTadShapeInfo, (LongPointer)new LongPointerWrapper(zTadOffsets));
        }
        return ret;
    }

    public INDArray accumulate(INDArray target, INDArray ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new RuntimeException("Input arrays are missing");
        }
        if (arrays.length == 1) {
            return target.addi(arrays[0]);
        }
        long len = target.lengthLong();
        PointerPointer dataPointers = new PointerPointer((long)arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            Nd4j.getCompressor().autoDecompress(arrays[i]);
            if (arrays[i].elementWiseStride() != 1) {
                throw new ND4JIllegalStateException("Native accumulation is applicable only to continuous INDArrays");
            }
            if (arrays[i].lengthLong() != len) {
                throw new ND4JIllegalStateException("All arrays should have equal length for accumulation");
            }
            dataPointers.put((long)i, arrays[i].data().addressPointer());
        }
        if (target.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.accumulateDouble(null, dataPointers, (DoublePointer)target.data().addressPointer(), arrays.length, len);
        } else if (target.data().dataType() == DataBuffer.Type.FLOAT) {
            this.nativeOps.accumulateFloat(null, dataPointers, (FloatPointer)target.data().addressPointer(), arrays.length, len);
        } else {
            this.nativeOps.accumulateHalf(null, dataPointers, (ShortPointer)target.data().addressPointer(), arrays.length, len);
        }
        return target;
    }

    public INDArray average(INDArray target, INDArray[] arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new RuntimeException("Input arrays are missing");
        }
        if (arrays.length == 1) {
            if (target == null) {
                return null;
            }
            return target.assign(arrays[0]);
        }
        long len = target != null ? target.lengthLong() : arrays[0].length();
        PointerPointer dataPointers = new PointerPointer((long)arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            Nd4j.getCompressor().autoDecompress(arrays[i]);
            if (arrays[i].elementWiseStride() != 1) {
                throw new ND4JIllegalStateException("Native averaging is applicable only to continuous INDArrays");
            }
            if (arrays[i].lengthLong() != len) {
                throw new ND4JIllegalStateException("All arrays should have equal length for averaging");
            }
            dataPointers.put((long)i, arrays[i].data().addressPointer());
        }
        if (arrays[0].data().dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.averageDouble(null, dataPointers, target == null ? null : (DoublePointer)target.data().addressPointer(), arrays.length, len, true);
        } else if (arrays[0].data().dataType() == DataBuffer.Type.FLOAT) {
            this.nativeOps.averageFloat(null, dataPointers, target == null ? null : (FloatPointer)target.data().addressPointer(), arrays.length, len, true);
        } else {
            this.nativeOps.averageHalf(null, dataPointers, target == null ? null : (ShortPointer)target.data().addressPointer(), arrays.length, len, true);
        }
        return target;
    }

    public INDArray average(INDArray target, Collection<INDArray> arrays) {
        return this.average(target, arrays.toArray(new INDArray[0]));
    }

    public INDArray average(INDArray[] arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new RuntimeException("Input arrays are missing");
        }
        INDArray ret = Nd4j.createUninitialized((long[])arrays[0].shape(), (char)arrays[0].ordering());
        return this.average(ret, arrays);
    }

    public INDArray average(Collection<INDArray> arrays) {
        return this.average(arrays.toArray(new INDArray[0]));
    }

    public void shuffle(INDArray array, Random rnd, int ... dimension) {
        this.shuffle(Collections.singletonList(array), rnd, dimension);
    }

    public void shuffle(Collection<INDArray> array, Random rnd, int ... dimension) {
        this.shuffle(new ArrayList<INDArray>(array), rnd, Collections.singletonList(dimension));
    }

    public void shuffle(List<INDArray> arrays, Random rnd, List<int[]> dimensions) {
        if (dimensions == null || dimensions.size() == 0) {
            throw new RuntimeException("Dimension can't be null or 0-length");
        }
        if (arrays == null || arrays.size() == 0) {
            throw new RuntimeException("No input arrays provided");
        }
        if (dimensions.size() > 1 && arrays.size() != dimensions.size()) {
            throw new IllegalStateException("Number of dimensions do not match number of arrays to shuffle");
        }
        int tadLength = 1;
        for (int i = 0; i < dimensions.get(0).length; ++i) {
            tadLength = (int)((long)tadLength * arrays.get(0).shape()[dimensions.get(0)[i]]);
        }
        long numTads = arrays.get(0).length() / (long)tadLength;
        int[] map = ArrayUtil.buildInterleavedVector((Random)rnd, (int)((int)numTads));
        PointerPointer dataPointers = new PointerPointer((long)arrays.size());
        PointerPointer shapePointers = new PointerPointer((long)arrays.size());
        PointerPointer tadPointers = new PointerPointer((long)arrays.size());
        PointerPointer offsetPointers = new PointerPointer((long)arrays.size());
        PointerPointer dummy = new PointerPointer(new Pointer[]{null});
        ArrayList<Pair> list = new ArrayList<Pair>();
        TADManager tadManager = Nd4j.getExecutioner().getTADManager();
        IntPointer ptrMap = new IntPointer(map);
        long[] ptrs = new long[arrays.size()];
        for (int i = 0; i < arrays.size(); ++i) {
            INDArray array = arrays.get(i);
            Nd4j.getCompressor().autoDecompress(array);
            int[] dimension = dimensions.size() > 1 ? dimensions.get(i) : dimensions.get(0);
            Pair tadBuffers = tadManager.getTADOnlyShapeInfo(array, dimension);
            list.add(tadBuffers);
            Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
            DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
            if (offsets.length() != numTads) {
                throw new ND4JIllegalStateException("Can't symmetrically shuffle arrays with non-equal number of TADs");
            }
            if (offsets == null) {
                throw new ND4JIllegalStateException("Offsets for shuffle can't be null");
            }
            dataPointers.put((long)i, array.data().addressPointer());
            shapePointers.put((long)i, array.shapeInfoDataBuffer().addressPointer());
            offsetPointers.put((long)i, offsets.addressPointer());
            tadPointers.put((long)i, ((DataBuffer)tadBuffers.getFirst()).addressPointer());
        }
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.shuffleDouble(dummy, dataPointers, shapePointers, dataPointers, shapePointers, arrays.size(), ptrMap, tadPointers, offsetPointers);
        } else if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.nativeOps.shuffleFloat(dummy, dataPointers, shapePointers, dataPointers, shapePointers, arrays.size(), ptrMap, tadPointers, offsetPointers);
        }
        dataPointers.address();
        shapePointers.address();
        tadPointers.address();
        offsetPointers.address();
    }

    public INDArray convertDataEx(DataBuffer.TypeEx typeSrc, INDArray source, DataBuffer.TypeEx typeDst) {
        if (source.isView()) {
            throw new UnsupportedOperationException("Impossible to compress View. Consider using dup() before. ");
        }
        DataBuffer buffer = this.convertDataEx(typeSrc, source.data(), typeDst);
        source.setData(buffer);
        if (buffer instanceof CompressedDataBuffer) {
            source.markAsCompressed(true);
        } else {
            source.markAsCompressed(false);
        }
        return source;
    }

    public DataBuffer convertDataEx(DataBuffer.TypeEx typeSrc, DataBuffer source, DataBuffer.TypeEx typeDst) {
        int elementSize = 0;
        if (typeDst.ordinal() <= 2) {
            elementSize = 1;
        } else if (typeDst.ordinal() <= 5) {
            elementSize = 2;
        } else if (typeDst.ordinal() == 6) {
            elementSize = 4;
        } else if (typeDst.ordinal() == 7) {
            elementSize = 8;
        } else {
            throw new UnsupportedOperationException("Unknown target TypeEx: " + typeDst.name());
        }
        DataBuffer buffer = null;
        if (CompressionUtils.goingToCompress((DataBuffer.TypeEx)typeSrc, (DataBuffer.TypeEx)typeDst)) {
            BytePointer pointer = new BytePointer(source.length() * (long)elementSize);
            CompressionDescriptor descriptor = new CompressionDescriptor(source, typeDst.name());
            descriptor.setCompressionType(CompressionType.LOSSY);
            descriptor.setCompressedLength(source.length() * (long)elementSize);
            buffer = new CompressedDataBuffer((Pointer)pointer, descriptor);
        } else {
            CompressedDataBuffer compressed = (CompressedDataBuffer)source;
            CompressionDescriptor descriptor = compressed.getCompressionDescriptor();
            buffer = Nd4j.createBuffer((long)descriptor.getNumberOfElements(), (boolean)true);
        }
        this.convertDataEx(typeSrc, source, typeDst, buffer);
        return buffer;
    }

    public void convertDataEx(DataBuffer.TypeEx typeSrc, Pointer source, DataBuffer.TypeEx typeDst, Pointer target, long length) {
        this.nativeOps.convertTypes(null, typeSrc.ordinal(), source, length, typeDst.ordinal(), target);
    }

    public void convertDataEx(DataBuffer.TypeEx typeSrc, Pointer source, DataBuffer.TypeEx typeDst, DataBuffer buffer) {
        this.convertDataEx(typeSrc, source, typeDst, buffer.addressPointer(), buffer.length());
    }

    public void convertDataEx(DataBuffer.TypeEx typeSrc, DataBuffer source, DataBuffer.TypeEx typeDst, DataBuffer target) {
        this.convertDataEx(typeSrc, source.addressPointer(), typeDst, target.addressPointer(), target.length());
    }

    public INDArray createSparseCSR(double[] data, int[] columns, int[] pointerB, int[] pointerE, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCSR(float[] data, int[] columns, int[] pointerB, int[] pointerE, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCSR(DataBuffer data, int[] columns, int[] pointerB, int[] pointerE, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCOO(double[] values, int[][] indices, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCOO(float[] values, int[][] indices, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCOO(double[] values, long[][] indices, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCOO(float[] values, long[][] indices, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCOO(DataBuffer values, DataBuffer indices, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCOO(DataBuffer values, DataBuffer indices, DataBuffer sparseInformation, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray createSparseCOO(DataBuffer values, DataBuffer indices, long[] sparseOffsets, int[] flags, int[] hiddenDimensions, int underlyingRank, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray sort(INDArray x, boolean descending) {
        if (x.isScalar()) {
            return x;
        }
        if (x.data().dataType() == DataBuffer.Type.FLOAT) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortFloat(null, (FloatPointer)x.data().addressPointer(), (LongPointer)x.shapeInfoDataBuffer().addressPointer(), descending);
        } else if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortDouble(null, (DoublePointer)x.data().addressPointer(), (LongPointer)x.shapeInfoDataBuffer().addressPointer(), descending);
        } else {
            throw new UnsupportedOperationException("Unknown dataype " + x.data().dataType());
        }
        return x;
    }

    public INDArray sort(INDArray x, boolean descending, int ... dimension) {
        if (x.isScalar()) {
            return x;
        }
        Arrays.sort(dimension);
        Pair tadBuffers = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(x, dimension);
        if (x.data().dataType() == DataBuffer.Type.FLOAT) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortTadFloat(null, (FloatPointer)x.data().addressPointer(), (LongPointer)x.shapeInfoDataBuffer().addressPointer(), (IntPointer)Nd4j.getConstantHandler().getConstantBuffer(dimension).addressPointer(), dimension.length, (LongPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), descending);
        } else if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortTadDouble(null, (DoublePointer)x.data().addressPointer(), (LongPointer)x.shapeInfoDataBuffer().addressPointer(), (IntPointer)Nd4j.getConstantHandler().getConstantBuffer(dimension).addressPointer(), dimension.length, (LongPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), descending);
        } else {
            throw new UnsupportedOperationException("Unknown dataype " + x.data().dataType());
        }
        return x;
    }

    public INDArray sortCooIndices(INDArray x) {
        throw new UnsupportedOperationException("Not an COO ndarray");
    }

    static {
        Nd4j.getBlasWrapper();
    }
}

