/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.ops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.nd4j.autodiff.samediff.serde.FlatBuffersMapper;
import org.nd4j.base.Preconditions;
import org.nd4j.compression.impl.AbstractCompressor;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.DataTypeEx;
import org.nd4j.linalg.api.buffer.Utf8Buffer;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.INDArrayStatistics;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.Batch;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpStatus;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.cpu.nativecpu.CpuTADManager;
import org.nd4j.linalg.cpu.nativecpu.ops.CpuOpContext;
import org.nd4j.linalg.cpu.nativecpu.rng.CpuNativeRandom;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.memory.MemcpyDirection;
import org.nd4j.linalg.primitives.AtomicBoolean;
import org.nd4j.linalg.primitives.Optional;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.nativeblas.LongPointerWrapper;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jCpu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOpExecutioner
extends DefaultOpExecutioner {
    private static final Logger log = LoggerFactory.getLogger(NativeOpExecutioner.class);
    private NativeOps loop = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private ConstantHandler constantHandler = Nd4j.getConstantHandler();
    private CpuTADManager tadManager = new CpuTADManager();
    private ThreadLocal<Map<Integer, PointerPointer>> inputShapes = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> inputBuffers = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> outputShapes = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> outputBuffers = new ThreadLocal();
    private ThreadLocal<Map<Integer, LongPointer>> iArgsPointer = new ThreadLocal();
    private ThreadLocal<Map<Integer, DoublePointer>> tArgsPointer = new ThreadLocal();
    private ThreadLocal<Map<Integer, BooleanPointer>> bArgsPointer = new ThreadLocal();
    private ThreadLocal<Map<Integer, ShortPointer>> halfArgsPointer = new ThreadLocal();
    protected Map<String, CustomOpDescriptor> customOps = null;
    protected ThreadLocal<PointerPointer> extraz = new ThreadLocal();
    protected AtomicBoolean experimentalMode = new AtomicBoolean(false);
    protected Map<String, Boolean> mklOverrides = new HashMap<String, Boolean>();
    private ThreadLocal<Map<Integer, Pointer>> batchPointers = new ThreadLocal();
    private ThreadLocal<Map<Integer, AggregateMemoryBlock>> memoryBlocks = new ThreadLocal();

    public NativeOpExecutioner() {
        this.tadManager.init(this.loop, this.constantHandler);
        this.experimentalMode.set(this.loop.isExperimentalEnabled());
        String env = System.getenv("ND4J_MKL_FALLBACK");
        if (env != null) {
            if (env.equalsIgnoreCase("true")) {
                Nd4jCpu.Environment.getInstance().setUseMKLDNN(false);
            } else {
                String[] split2;
                for (String name : split2 = env.toLowerCase().split(",")) {
                    this.mklOverrides.put(name, new Boolean(true));
                }
            }
        }
    }

    public INDArray exec(Op op) {
        this.checkForCompression(op);
        if (op instanceof ScalarOp) {
            ScalarOp s = (ScalarOp)op;
            this.exec(s);
        } else if (op instanceof TransformOp) {
            TransformOp t = (TransformOp)op;
            this.exec(t);
        } else if (op instanceof ReduceOp) {
            ReduceOp ac = (ReduceOp)op;
            this.exec(ac);
        } else if (op instanceof IndexAccumulation) {
            IndexAccumulation iac = (IndexAccumulation)op;
            this.exec(iac);
        } else if (op instanceof BroadcastOp) {
            BroadcastOp broadcastOp = (BroadcastOp)op;
            this.exec(broadcastOp);
        } else if (op instanceof RandomOp) {
            RandomOp rngOp = (RandomOp)op;
            this.exec(rngOp, Nd4j.getRandom());
        }
        return op.z();
    }

    public INDArray exec(IndexAccumulation op) {
        this.checkForCompression((Op)op);
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        int[] dimension = Shape.normalizeAxis((int)op.x().rank(), (int[])op.dimensions().toIntVector());
        boolean keepDims = op.isKeepDims();
        long[] retShape = Shape.reductionShape((INDArray)op.x(), (int[])dimension, (boolean)true, (boolean)keepDims);
        if (op.z() == null || op.x() == op.z()) {
            INDArray ret = Nd4j.createUninitialized((DataType)DataType.LONG, (long[])retShape);
            op.setZ(ret);
        } else if (!Arrays.equals(retShape, op.z().shape())) {
            throw new IllegalStateException("Z array shape does not match expected return type for op " + op + ": expected shape " + Arrays.toString(retShape) + ", z.shape()=" + Arrays.toString(op.z().shape()));
        }
        op.validateDataTypes();
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension, DataType.INT).addressPointer();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets});
        long st = this.profilingConfigurableHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        Pointer x = op.x().data().addressPointer();
        Pointer z = op.z().data().addressPointer();
        if (op.z().isScalar()) {
            this.loop.execIndexReduceScalar(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null);
        } else {
            this.loop.execIndexReduce(dummy, op.opNum(), x, (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()), z, (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null);
        }
        this.profilingConfigurableHookOut((Op)op, st);
        return op.z();
    }

    public INDArray exec(Variance op) {
        return this.exec((ReduceOp)op);
    }

    public INDArray exec(ReduceOp op) {
        INDArray ret;
        block44: {
            block43: {
                block42: {
                    Pair<DataBuffer, DataBuffer> yTadBuffers;
                    Pair<DataBuffer, DataBuffer> tadBuffers;
                    int[] dimension;
                    block41: {
                        Preconditions.checkNotNull((Object)op.x(), (String)"Op.x() cannot be null: Was null for op %s", (Object)op);
                        op.validateDataTypes();
                        dimension = Shape.normalizeAxis((int)op.x().rank(), (int[])op.dimensions().toIntVector());
                        if (this.extraz.get() == null) {
                            this.extraz.set(new PointerPointer(32L));
                        }
                        boolean keepDims = op.isKeepDims();
                        long[] retShape = Shape.reductionShape((INDArray)op.x(), (int[])dimension, (boolean)true, (boolean)keepDims);
                        if (op.x().isVector() && op.x().length() == (long)ArrayUtil.prod((long[])retShape) && ArrayUtil.prodLong((long[])retShape) > 1L && op.y() == null) {
                            return op.noOp();
                        }
                        if (op.z() == null || op.z() == op.x()) {
                            if (op.isComplexAccumulation()) {
                                long xT = op.x().tensorsAlongDimension(dimension);
                                long yT = op.y().tensorsAlongDimension(dimension);
                                ret = Nd4j.create((DataType)op.resultType(), (long[])new long[]{xT, yT});
                            } else {
                                if (op.y() != null) {
                                    if (op.x().lengthLong() == op.y().lengthLong()) {
                                        if (op.x().tensorsAlongDimension(dimension) != op.y().tensorsAlongDimension(dimension)) {
                                            throw new ND4JIllegalStateException("Number of TADs along dimension don't match: (x shape = " + Arrays.toString(op.x().shape()) + ", y shape = " + Arrays.toString(op.y().shape()) + ", dimension = " + Arrays.toString(dimension) + ")");
                                        }
                                    } else {
                                        long xTADSize = op.x().lengthLong() / op.x().tensorsAlongDimension(dimension);
                                        if (xTADSize != op.y().length()) {
                                            throw new ND4JIllegalStateException("Size of TADs along dimension don't match for pairwise execution: (x TAD size = " + xTADSize + ", y size = " + op.y().lengthLong());
                                        }
                                    }
                                }
                                ret = Nd4j.create((DataType)op.resultType(), (long[])retShape);
                            }
                            op.setZ(ret);
                        } else {
                            long shapeProduct;
                            long l = shapeProduct = retShape.length == 0 ? 1L : ArrayUtil.prodLong((long[])retShape);
                            if (!op.isComplexAccumulation() && op.z().lengthLong() != shapeProduct) {
                                throw new ND4JIllegalStateException("Shape of target array for reduction [" + Arrays.toString(op.z().shape()) + "] doesn't match expected [" + Arrays.toString(retShape) + "]");
                            }
                            if (op.isComplexAccumulation()) {
                                long xT = op.x().tensorsAlongDimension(dimension);
                                long yT = op.y().tensorsAlongDimension(dimension);
                                if (op.z().lengthLong() != xT * yT) {
                                    throw new ND4JIllegalStateException("Shape of target array for reduction [" + Arrays.toString(op.z().shape()) + "] doesn't match expected [" + xT * yT + "]");
                                }
                            }
                            ret = op.z();
                        }
                        tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
                        yTadBuffers = null;
                        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
                        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
                        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
                        boolean tvf = false;
                        if (op.y() != null && op.x().tensorAlongDimension(0L, dimension).lengthLong() == op.y().lengthLong()) {
                            tvf = true;
                        }
                        if (op.isComplexAccumulation()) {
                            yTadBuffers = this.tadManager.getTADOnlyShapeInfo(op.y(), dimension);
                            if (op.x().tensorAlongDimension(0L, dimension).lengthLong() != op.y().tensorAlongDimension(0L, dimension).lengthLong()) {
                                throw new ND4JIllegalStateException("Impossible to issue AllDistances operation: TAD lengths mismatch along given dimension: x TAD length = " + op.x().tensorAlongDimension(0L, dimension).lengthLong() + ", y TAD length " + op.y().tensorAlongDimension(0L, dimension).lengthLong());
                            }
                        }
                        long st = this.profilingConfigurableHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
                        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension, DataType.INT).addressPointer();
                        if (!(op instanceof Variance)) break block41;
                        if (ret.isScalar()) {
                            this.loop.execSummaryStatsScalar(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, ((Variance)op).isBiasCorrected());
                        } else {
                            Variance var = (Variance)op;
                            try {
                                this.loop.execSummaryStats(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null, var.isBiasCorrected(), null, null);
                            }
                            catch (Throwable t) {
                                String str = this.opInfoString((Op)op, Optional.of((Object)dimension));
                                throw new RuntimeException("Native AccumulationOp execution (double) failed: " + str, t);
                            }
                        }
                    }
                    if (op.y() == null || op.getOpType() != Op.Type.REDUCE3) break block42;
                    if (op.isComplexAccumulation()) {
                        try {
                            this.loop.execReduce3All(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null, (LongPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), (LongPointer)((DataBuffer)yTadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)yTadBuffers.getSecond()).addressPointer()));
                        }
                        catch (Throwable t) {
                            String str = this.opInfoString((Op)op, Optional.of((Object)dimension));
                            throw new RuntimeException("Native AccumulationOp execution (double) failed: " + str, t);
                        }
                    } else if (ret.isScalar()) {
                        this.loop.execReduce3Scalar(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
                    } else {
                        try {
                            this.loop.execReduce3(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null, null, null, null, null);
                        }
                        catch (Throwable t) {
                            String str = this.opInfoString((Op)op, Optional.of((Object)dimension));
                            throw new RuntimeException("Native AccumulationOp execution (double) failed: " + str, t);
                        }
                    }
                }
                if (!ret.isScalar()) break block43;
                switch (op.getOpType()) {
                    case REDUCE_FLOAT: {
                        this.loop.execReduceFloat(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
                        break block44;
                    }
                    case REDUCE_BOOL: {
                        this.loop.execReduceBool(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()), ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
                        break block44;
                    }
                    case REDUCE_SAME: {
                        this.loop.execReduceSame(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()), ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
                        break block44;
                    }
                    case REDUCE_LONG: {
                        this.loop.execReduceLong(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()), ret.data().addressPointer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, null);
                        break block44;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported op used in reduce: " + op.getOpType());
                    }
                }
            }
            switch (op.getOpType()) {
                case REDUCE_FLOAT: {
                    this.loop.execReduceFloat(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null);
                    break;
                }
                case REDUCE_LONG: {
                    this.loop.execReduceLong(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null);
                    break;
                }
                case REDUCE_SAME: {
                    this.loop.execReduceSame(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null);
                    break;
                }
                case REDUCE_BOOL: {
                    this.loop.execReduceBool(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported op used in reduce: " + op.getOpType());
                }
            }
        }
        return ret;
    }

    private void invokeScalarAlongDimension(ScalarOp op) {
        int[] dimension = op.dimensions().toIntVector();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer hostTadOffsets = ((DataBuffer)tadBuffers.getSecond()).addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
        devTadShapeInfoZ = ((DataBuffer)tadBuffersZ.getFirst()).addressPointer();
        devTadOffsetsZ = ((DataBuffer)tadBuffersZ.getSecond()).addressPointer();
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        switch (op.getOpType()) {
            case SCALAR: {
                this.loop.execScalar(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null, (LongPointer)hostTadShapeInfo, (LongPointer)hostTadOffsets, (LongPointer)devTadShapeInfoZ, (LongPointer)devTadOffsetsZ);
                break;
            }
            case SCALAR_BOOL: {
                this.loop.execScalarBool(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()), op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null, (LongPointer)hostTadShapeInfo, (LongPointer)hostTadOffsets, (LongPointer)devTadShapeInfoZ, (LongPointer)devTadOffsetsZ);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public INDArray exec(ScalarOp op) {
        long st = this.profilingConfigurableHookIn((Op)op, new DataBuffer[0]);
        if (op.x().lengthLong() != op.z().lengthLong()) {
            throw new ND4JIllegalStateException("op.X length should be equal to op.Z length: x.length()=" + op.x().length() + ", z.length()=" + op.z().length() + " - x shape info = [" + Arrays.toString(op.x().shapeInfoDataBuffer().asInt()) + "], z shape info = [" + Arrays.toString(op.z().shapeInfoDataBuffer().asInt()) + "]");
        }
        if (op.dimensions() != null) {
            this.invokeScalarAlongDimension(op);
            return op.z();
        }
        switch (op.getOpType()) {
            case SCALAR: {
                this.loop.execScalar(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.scalar().data().addressPointer(), (LongPointer)op.scalar().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()));
                break;
            }
            case SCALAR_BOOL: {
                this.loop.execScalarBool(null, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.scalar().data().addressPointer(), (LongPointer)op.scalar().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()));
                break;
            }
            default: {
                throw new ND4JIllegalStateException("Unknown op type: [" + op.getOpType() + "]");
            }
        }
        this.profilingConfigurableHookOut((Op)op, st);
        return op.z();
    }

    private Pointer getPointerForExtraArgs(Op op, DataType type) {
        if (op.extraArgs() != null) {
            DataBuffer eadb = op.extraArgsDataBuff(type);
            if (eadb != null) {
                return eadb.addressPointer();
            }
            return null;
        }
        return null;
    }

    private void exec(TransformOp op) {
        long st = 0L;
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        PointerPointer dummy = this.extraz.get();
        if (op.opNum() == 31 && op.y() != null && op.y().isScalar()) {
            op.setY(Nd4j.valueArrayOf((long[])op.x().shape(), (double)op.y().getDouble(0L)));
        }
        if (op.opName().equalsIgnoreCase("ismax") && op.extraArgs() != null && op.extraArgs().length > 0) {
            int[] dimension = new int[((Integer)op.extraArgs()[0]).intValue()];
            for (int i = 0; i < dimension.length; ++i) {
                dimension[i] = (Integer)op.extraArgs()[i + 1];
            }
            Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
            Pointer tad = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
            DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
            Pointer off = offsets == null ? null : offsets.addressPointer();
            dummy.put(0L, tad);
            dummy.put(1L, off);
            st = this.profilingConfigurableHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        } else {
            st = this.profilingConfigurableHookIn((Op)op, new DataBuffer[0]);
        }
        if (op.y() != null) {
            if (op.z() == null) {
                op.setZ(Nd4j.create((DataType)op.resultType(), (long[])op.x().shape()));
            }
            op.validateDataTypes(this.experimentalMode.get());
            int xEWS = op.x().elementWiseStride();
            int yEWS = op.y().elementWiseStride();
            int zEWS = op.z().elementWiseStride();
            boolean xRow = op.x().isRowVector();
            boolean yRow = op.y().isRowVector();
            boolean zRow = op.z().isRowVector();
            if (op.x().length() != op.y().length() || op.x().length() != op.z().length()) {
                throw new ND4JIllegalStateException("X, Y and Z arguments should have the same length for PairwiseTransform " + op.opName() + ". x: length " + op.x().length() + ", shape " + Arrays.toString(op.x().shape()) + "; y: " + op.y().length() + ", shape " + Arrays.toString(op.y().shape()) + "; z: " + op.z().length() + ", shape " + Arrays.toString(op.z().shape()));
            }
            switch (op.getOpType()) {
                case TRANSFORM_ANY: 
                case TRANSFORM_FLOAT: 
                case TRANSFORM_STRICT: 
                case TRANSFORM_SAME: {
                    if (!this.experimentalMode.get()) {
                        Preconditions.checkArgument((op.x().dataType() == op.y().dataType() || op.y().dataType() == DataType.BOOL ? 1 : 0) != 0, (String)("Op.X and Op.Y must have the same data type, but got " + op.x().dataType() + " vs " + op.y().dataType()));
                    }
                    this.loop.execPairwiseTransform(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.z().dataType()));
                    break;
                }
                case TRANSFORM_BOOL: 
                case PAIRWISE_BOOL: {
                    this.loop.execPairwiseTransformBool(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, this.getPointerForExtraArgs((Op)op, op.x().dataType()));
                }
            }
        } else {
            if (op.z() == null) {
                op.setZ(Nd4j.create((DataType)op.resultType(), (long[])op.x().shape()));
            }
            op.validateDataTypes(this.experimentalMode.get());
            switch (op.getOpType()) {
                case TRANSFORM_FLOAT: {
                    Pointer xtraz = this.getPointerForExtraArgs((Op)op, op.z().dataType());
                    this.loop.execTransformFloat(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, xtraz);
                    break;
                }
                case TRANSFORM_STRICT: {
                    Pointer xtraz = this.getPointerForExtraArgs((Op)op, op.z().dataType());
                    this.loop.execTransformStrict(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, xtraz);
                    break;
                }
                case TRANSFORM_SAME: {
                    Pointer xtraz = this.getPointerForExtraArgs((Op)op, op.z().dataType());
                    this.loop.execTransformSame(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, xtraz);
                    break;
                }
                case TRANSFORM_ANY: {
                    Pointer xtraz = this.getPointerForExtraArgs((Op)op, op.x().dataType());
                    int opNum = op.opNum();
                    this.loop.execTransformAny(dummy, opNum, op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, xtraz);
                    break;
                }
                case TRANSFORM_BOOL: {
                    Pointer xtraz = this.getPointerForExtraArgs((Op)op, op.x().dataType());
                    int opNum = op.opNum();
                    this.loop.execTransformBool(dummy, opNum, op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, xtraz);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown transform type: [" + op.getOpType() + "]");
                }
            }
        }
        this.profilingConfigurableHookOut((Op)op, st);
    }

    public INDArray exec(BroadcastOp op) {
        long st = this.profilingConfigurableHookIn((Op)op, new DataBuffer[0]);
        op.validateDataTypes(this.experimentalMode.get());
        int[] dimension = op.dimensions().toIntVector();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer hostTadOffsets = ((DataBuffer)tadBuffers.getSecond()).addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
        devTadShapeInfoZ = ((DataBuffer)tadBuffersZ.getFirst()).addressPointer();
        devTadOffsetsZ = ((DataBuffer)tadBuffersZ.getSecond()).addressPointer();
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets, devTadShapeInfoZ, devTadOffsetsZ});
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension, DataType.INT).addressPointer();
        switch (op.getOpType()) {
            case BROADCAST: {
                this.loop.execBroadcast(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null);
                break;
            }
            case BROADCAST_BOOL: {
                this.loop.execBroadcastBool(dummy, op.opNum(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.dimensions().data().addressPointer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation type: [" + op.getOpType() + "]");
            }
        }
        return op.z();
    }

    protected <T extends Aggregate> Pointer getPointer(Batch<T> batch) {
        if (this.batchPointers.get() == null) {
            this.batchPointers.set(new HashMap());
        }
        if (!this.batchPointers.get().containsKey(batch.opNum())) {
            IntPointer pointer = new IntPointer(batch.getSample().getRequiredBatchMemorySize() / 4L);
            this.batchPointers.get().put(batch.opNum(), (Pointer)pointer);
            return pointer;
        }
        return this.batchPointers.get().get(batch.opNum());
    }

    public <T extends Aggregate> void exec(Batch<T> batch) {
        IntPointer pointer = (IntPointer)this.getPointer(batch);
        int maxTypes = 5;
        int maxIntArrays = batch.getSample().maxIntArrays();
        int maxArraySize = batch.getSample().maxIntArraySize();
        int indexPos = maxTypes * Batch.getBatchLimit();
        int intArraysPos = indexPos + batch.getSample().maxIndexArguments() * Batch.getBatchLimit();
        int realPos = (intArraysPos + maxIntArrays * maxArraySize * Batch.getBatchLimit()) / (Nd4j.dataType() == DataType.DOUBLE ? 2 : 1);
        int argsPos = (realPos + batch.getSample().maxRealArguments() * Batch.getBatchLimit()) / (Nd4j.dataType() == DataType.DOUBLE ? 1 : 2);
        int shapesPos = argsPos + batch.getSample().maxArguments() * Batch.getBatchLimit();
        DataType dataType = null;
        for (int i = 0; i < batch.getNumAggregates(); ++i) {
            int e;
            Aggregate op = (Aggregate)batch.getAggregates().get(i);
            if (i == 0) {
                dataType = ((INDArray)op.getArguments().get(0)).dataType();
            }
            int idx = i * maxTypes;
            pointer.put((long)idx, op.getArguments().size());
            pointer.put((long)(idx + 1), op.getShapes().size());
            pointer.put((long)(idx + 2), op.getIndexingArguments().size());
            pointer.put((long)(idx + 3), op.getRealArguments().size());
            pointer.put((long)(idx + 4), op.getIntArrayArguments().size());
            for (int e2 = 0; e2 < op.getIndexingArguments().size(); ++e2) {
                idx = indexPos + i * batch.getSample().maxIndexArguments();
                pointer.put((long)(idx + e2), ((Integer)op.getIndexingArguments().get(e2)).intValue());
            }
            int bsize = maxIntArrays * maxArraySize;
            for (int e3 = 0; e3 < op.getIntArrayArguments().size(); ++e3) {
                int step = i * bsize + e3 * maxArraySize;
                if (op.getIntArrayArguments().get(e3) == null) continue;
                for (int x = 0; x < ((int[])op.getIntArrayArguments().get(e3)).length; ++x) {
                    idx = intArraysPos + step + x;
                    pointer.put((long)idx, ((int[])op.getIntArrayArguments().get(e3))[x]);
                }
            }
            switch (dataType) {
                case FLOAT: {
                    FloatPointer fPtr = new FloatPointer((Pointer)pointer);
                    for (e = 0; e < op.getRealArguments().size(); ++e) {
                        idx = realPos + i * op.maxRealArguments();
                        fPtr.put((long)(idx + e), ((Number)op.getRealArguments().get(e)).floatValue());
                    }
                    break;
                }
                case DOUBLE: {
                    DoublePointer dPtr = new DoublePointer((Pointer)pointer);
                    for (int e4 = 0; e4 < op.getRealArguments().size(); ++e4) {
                        idx = realPos + i * op.maxRealArguments();
                        dPtr.put((long)(idx + e4), ((Number)op.getRealArguments().get(e4)).doubleValue());
                    }
                    break;
                }
                default: {
                    throw new ND4JIllegalArgumentException("Only FLOAT and DOUBLE datatypes are supported");
                }
            }
            if (this.extraz.get() == null) {
                this.extraz.set(new PointerPointer(32L));
            }
            PointerPointer ptrPtr = new PointerPointer((Pointer)pointer);
            for (e = 0; e < op.getArguments().size(); ++e) {
                idx = argsPos + i * batch.getSample().maxArguments();
                if (op.getArguments().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), ((INDArray)op.getArguments().get(e)).data().addressPointer());
            }
            for (e = 0; e < op.getShapes().size(); ++e) {
                idx = shapesPos + i * batch.getSample().maxShapes();
                if (op.getShapes().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), ((DataBuffer)op.getShapes().get(e)).addressPointer());
            }
        }
        this.loop.execAggregateBatch(null, batch.getNumAggregates(), batch.opNum(), batch.getSample().maxArguments(), batch.getSample().maxShapes(), batch.getSample().maxIntArrays(), batch.getSample().maxIntArraySize(), batch.getSample().maxIndexArguments(), batch.getSample().maxRealArguments(), (Pointer)pointer, (int)FlatBuffersMapper.getDataTypeAsByte((DataType)dataType));
    }

    public void exec(List<Aggregate> batch) {
        if (batch.size() == 0) {
            return;
        }
        List batches = Batch.getBatches(batch);
        for (Batch single : batches) {
            this.exec(single);
        }
    }

    public void exec(Aggregate op) {
        int x;
        if (this.memoryBlocks.get() == null) {
            this.memoryBlocks.set(new HashMap());
        }
        if (this.memoryBlocks.get().get(op.opNum()) == null) {
            this.memoryBlocks.get().put(op.opNum(), new AggregateMemoryBlock(op));
        }
        AggregateMemoryBlock block = this.memoryBlocks.get().get(op.opNum());
        int numArguments = op.getArguments().size();
        int numIndexArguments = op.getIndexingArguments().size();
        int numRealArguments = op.getRealArguments().size();
        int numShapes = op.getShapes().size();
        int numIntArrays = op.getIntArrayArguments().size();
        PointerPointer arguments = block.getArgumentsPointer();
        ArrayList<IntPointer> pointers = new ArrayList<IntPointer>();
        PointerPointer intArrays = block.getArraysPointer();
        DataType dataType = ((INDArray)op.getArguments().get(0)).dataType();
        for (int x2 = 0; x2 < numArguments; ++x2) {
            arguments.put((long)x2, op.getArguments().get(x2) == null ? null : ((INDArray)op.getArguments().get(x2)).data().addressPointer());
        }
        PointerPointer shapes = block.getShapesPointer();
        for (int x3 = 0; x3 < numShapes; ++x3) {
            if (((DataBuffer)op.getShapes().get(x3)).dataType() != DataType.LONG) {
                throw new RuntimeException("ShapeBuffers should have LONG data opType");
            }
            shapes.put((long)x3, op.getShapes().get(x3) == null ? null : ((DataBuffer)op.getShapes().get(x3)).addressPointer());
        }
        IntPointer pointer = block.getIndexingPointer();
        for (int x4 = 0; x4 < numIndexArguments; ++x4) {
            pointer.put((long)x4, ((Integer)op.getIndexingArguments().get(x4)).intValue());
        }
        double[] reals = new double[numRealArguments];
        block7: for (x = 0; x < numRealArguments; ++x) {
            switch (dataType) {
                case FLOAT: {
                    ((FloatPointer)block.getRealArgumentsPointer()).put((long)x, ((Number)op.getRealArguments().get(x)).floatValue());
                    continue block7;
                }
                case DOUBLE: {
                    ((DoublePointer)block.getRealArgumentsPointer()).put((long)x, ((Number)op.getRealArguments().get(x)).doubleValue());
                    continue block7;
                }
                default: {
                    throw new ND4JIllegalArgumentException("Only FLOAT and DOUBLE datatypes are supported");
                }
            }
        }
        for (x = 0; x < numIntArrays; ++x) {
            IntPointer intPtr = block.getIntArrays().get(x);
            intPtr.put((int[])op.getIntArrayArguments().get(x), 0, ((int[])op.getIntArrayArguments().get(x)).length);
            intArrays.put((long)x, (Pointer)intPtr);
            pointers.add(intPtr);
        }
        this.loop.execAggregate(null, op.opNum(), arguments, numArguments, shapes, numShapes, pointer, numIndexArguments, intArrays, numIntArrays, block.getRealArgumentsPointer(), numRealArguments, (int)FlatBuffersMapper.getDataTypeAsByte((DataType)dataType));
    }

    public Properties getEnvironmentInformation() {
        Properties properties = super.getEnvironmentInformation();
        properties.put("backend", "CPU");
        properties.put("omp.threads", (Object)this.loop.ompGetMaxThreads());
        properties.put("blas.threads", (Object)Nd4j.factory().blas().getMaxThreads());
        properties.put("blas.vendor", Nd4j.factory().blas().getBlasVendor().toString());
        properties.put("memory.free", (Object)(Pointer.maxBytes() - Pointer.totalBytes()));
        if (PerformanceTracker.getInstance() != null) {
            properties.put("memoryBandwidth", PerformanceTracker.getInstance().getCurrentBandwidth());
        }
        return properties;
    }

    public INDArray exec(RandomOp op) {
        return this.exec(op, Nd4j.getRandom());
    }

    public INDArray exec(RandomOp op, Random rng) {
        if (!(rng instanceof CpuNativeRandom)) {
            throw new IllegalStateException("You should use one of NativeRandom classes for NativeOperations execution. Op class: " + op.getClass().getName());
        }
        long st = this.profilingConfigurableHookIn((Op)op, new DataBuffer[0]);
        Preconditions.checkArgument((boolean)op.z().isR(), (String)"Op.Z must have one of floating point types");
        if (op.x() != null && op.y() != null && op.z() != null) {
            this.loop.execRandom(null, op.opNum(), rng.getStatePointer(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.y().data().addressPointer(), (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.extraArgsDataBuff(op.z().dataType()).addressPointer());
        } else if (op.x() != null && op.z() != null) {
            this.loop.execRandom(null, op.opNum(), rng.getStatePointer(), op.x().data().addressPointer(), (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, null, op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.extraArgsDataBuff(op.z().dataType()).addressPointer());
        } else {
            this.loop.execRandom(null, op.opNum(), rng.getStatePointer(), op.z().data().addressPointer(), (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, null, op.extraArgsDataBuff(op.z().dataType()).addressPointer());
        }
        this.profilingConfigurableHookOut((Op)op, st);
        return op.z();
    }

    public TADManager getTADManager() {
        return this.tadManager;
    }

    public INDArray thresholdEncode(INDArray input, double threshold) {
        return this.thresholdEncode(input, threshold, null);
    }

    public INDArray thresholdEncode(INDArray input, double threshold, Integer boundary) {
        int cntAbs = this.loop.estimateThreshold(null, input.data().addressPointer(), (LongPointer)input.shapeInfoDataBuffer().addressPointer(), (int)input.length(), (float)threshold);
        if (cntAbs < 2) {
            return null;
        }
        if (boundary != null) {
            cntAbs = Math.min(cntAbs, boundary);
        }
        DataBuffer buffer = input.data();
        long originalLength = buffer.length() * (long)Nd4j.sizeOfDataType((DataType)buffer.dataType());
        int compressedLength = cntAbs + 4;
        DataBuffer encodedBuffer = Nd4j.getMemoryManager().getCurrentWorkspace() == null ? Nd4j.getDataBufferFactory().createInt((long)(4 + cntAbs), false) : Nd4j.getDataBufferFactory().createInt((long)(4 + cntAbs), false, Nd4j.getMemoryManager().getCurrentWorkspace());
        encodedBuffer.put(0L, cntAbs);
        encodedBuffer.put(1L, (int)buffer.length());
        encodedBuffer.put(2L, Float.floatToIntBits((float)threshold));
        encodedBuffer.put(3L, 0);
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.setCompressedLength((long)(compressedLength * 4));
        descriptor.setOriginalLength(originalLength);
        descriptor.setOriginalElementSize((long)Nd4j.sizeOfDataType((DataType)buffer.dataType()));
        descriptor.setNumberOfElements(buffer.length());
        descriptor.setCompressionAlgorithm("THRESHOLD");
        descriptor.setCompressionType(CompressionType.LOSSLESS);
        Nd4j.getNDArrayFactory().convertDataEx(AbstractCompressor.getBufferTypeEx((DataBuffer)buffer), buffer.addressPointer(), DataTypeEx.THRESHOLD, encodedBuffer.addressPointer(), buffer.length());
        Nd4j.getAffinityManager().tagLocation(buffer, AffinityManager.Location.HOST);
        return Nd4j.createArrayFromShapeBuffer((DataBuffer)encodedBuffer, (DataBuffer)input.shapeInfoDataBuffer());
    }

    public INDArray thresholdDecode(INDArray encoded, INDArray target) {
        DataBuffer buffer = encoded.data();
        if (buffer.dataType() != DataType.INT) {
            throw new ND4JIllegalStateException("thresholdEncoded array should have dataType of INT");
        }
        long compressedLength = buffer.getInt(0L);
        long originalLength = buffer.getInt(1L);
        float threshold = buffer.getInt(2L);
        if (target.lengthLong() != originalLength) {
            throw new ND4JIllegalStateException("originalLength [" + originalLength + "] stored in encoded array doesn't match target length [" + target.lengthLong() + "]");
        }
        DataTypeEx typeDst = AbstractCompressor.getBufferTypeEx((DataBuffer)target.data());
        this.loop.convertTypes(null, DataTypeEx.THRESHOLD.ordinal(), buffer.addressPointer(), target.length(), typeDst.ordinal(), target.data().addressPointer());
        return target;
    }

    public long bitmapEncode(INDArray indArray, INDArray target, double threshold) {
        long length = indArray.lengthLong();
        long tLen = target.data().length();
        if (tLen != length / 16L + 5L) {
            throw new ND4JIllegalStateException("Length of target array should be " + (length / 16L + 5L));
        }
        if (target.data().dataType() != DataType.INT) {
            throw new ND4JIllegalStateException("Target array should have INT dataType");
        }
        DataBuffer buffer = target.data();
        buffer.put(0L, (int)length);
        buffer.put(1L, (int)length);
        buffer.put(2L, Float.floatToIntBits((float)threshold));
        buffer.put(3L, 1);
        long affected = this.loop.encodeBitmap(null, indArray.data().addressPointer(), (LongPointer)indArray.shapeInfoDataBuffer().addressPointer(), length, (IntPointer)buffer.addressPointer(), (float)threshold);
        return affected;
    }

    public INDArray bitmapDecode(INDArray encoded, INDArray target) {
        this.loop.decodeBitmap(null, encoded.data().addressPointer(), target.length(), target.data().addressPointer(), (LongPointer)target.shapeInfoDataBuffer().addressPointer());
        return target;
    }

    public synchronized Map<String, CustomOpDescriptor> getCustomOperations() {
        if (this.customOps == null) {
            String[] split2;
            String list = this.loop.getAllCustomOps();
            if (list == null || list.isEmpty()) {
                log.warn("No customs ops available!");
                this.customOps = Collections.emptyMap();
                return this.customOps;
            }
            HashMap<String, CustomOpDescriptor> map = new HashMap<String, CustomOpDescriptor>();
            for (String op : split2 = list.split(";")) {
                if (op == null || op.isEmpty()) continue;
                String[] another = op.split(":");
                CustomOpDescriptor descriptor = CustomOpDescriptor.builder().hash(Long.valueOf(another[1]).longValue()).numInputs(Integer.valueOf(another[2]).intValue()).numOutputs(Integer.valueOf(another[3]).intValue()).allowsInplace(Integer.valueOf(another[4]) == 1).numTArgs(Integer.valueOf(another[5]).intValue()).numIArgs(Integer.valueOf(another[6]).intValue()).build();
                map.put(another[0], descriptor);
            }
            this.customOps = Collections.unmodifiableMap(map);
        }
        return this.customOps;
    }

    private PointerPointer getPointerPointerFrom(ThreadLocal<Map<Integer, PointerPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, PointerPointer> store = new HashMap<Integer, PointerPointer>();
            store.put(numArguments, new PointerPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            PointerPointer pointerPointer = new PointerPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private ShortPointer getShortPointerFrom(ThreadLocal<Map<Integer, ShortPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, ShortPointer> store = new HashMap<Integer, ShortPointer>();
            store.put(numArguments, new ShortPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            ShortPointer pointerPointer = new ShortPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private LongPointer getLongPointerFrom(ThreadLocal<Map<Integer, LongPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, LongPointer> store = new HashMap<Integer, LongPointer>();
            store.put(numArguments, new LongPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            LongPointer pointerPointer = new LongPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private DoublePointer getDoublePointerFrom(ThreadLocal<Map<Integer, DoublePointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, DoublePointer> store = new HashMap<Integer, DoublePointer>();
            store.put(numArguments, new DoublePointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            DoublePointer pointerPointer = new DoublePointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private BooleanPointer getBooleanPointerFrom(ThreadLocal<Map<Integer, BooleanPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, BooleanPointer> store = new HashMap<Integer, BooleanPointer>();
            store.put(numArguments, new BooleanPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            BooleanPointer pointerPointer = new BooleanPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private PointerPointer getInputShapes(int numArguments) {
        return this.getPointerPointerFrom(this.inputShapes, numArguments);
    }

    private PointerPointer getInputBuffers(int numArguments) {
        return this.getPointerPointerFrom(this.inputBuffers, numArguments);
    }

    private PointerPointer getOutputShapes(int numArguments) {
        return this.getPointerPointerFrom(this.outputShapes, numArguments);
    }

    private PointerPointer getOutputBuffers(int numArguments) {
        return this.getPointerPointerFrom(this.outputBuffers, numArguments);
    }

    public INDArray[] exec(@NonNull CustomOp op) {
        if (op == null) {
            throw new NullPointerException("op is marked @NonNull but is null");
        }
        long st = this.profilingConfigurableHookIn(op);
        if (op.numOutputArguments() == 0 && !op.isInplaceCall()) {
            try {
                List<LongShapeDescriptor> list = this.calculateOutputShape(op);
                if (list.isEmpty()) {
                    throw new ND4JIllegalStateException("Op name " + op.opName() + " failed to execute. You can't execute non-inplace CustomOp without outputs being specified");
                }
                for (LongShapeDescriptor shape : list) {
                    op.addOutputArgument(new INDArray[]{Nd4j.create((LongShapeDescriptor)shape, (boolean)false)});
                }
            }
            catch (Exception e) {
                throw new ND4JIllegalStateException("Op name " + op.opName() + " failed to execute. You can't execute non-inplace CustomOp without outputs being specified");
            }
        }
        String name = op.opName();
        OpContext context = this.buildContext();
        context.markInplace(op.isInplaceCall());
        context.setRngStates(Nd4j.getRandom().rootState(), Nd4j.getRandom().nodeState());
        context.setInputArrays(op.inputArguments());
        context.setOutputArrays(op.outputArguments());
        context.setBArguments(op.bArgs());
        context.setIArguments(op.iArgs());
        context.setTArguments(op.tArgs());
        try {
            INDArray[] result = this.exec(op, context);
            Pair states = context.getRngStates();
            Nd4j.getRandom().setStates(((Long)states.getFirst()).longValue(), ((Long)states.getSecond()).longValue());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Op [" + name + "] execution failed", e);
        }
    }

    protected LongShapeDescriptor getShapeFromPointer(LongPointer ptr) {
        int rank2 = (int)ptr.get(0L);
        long[] shape = new long[rank2 * 2 + 4];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = ptr.get((long)i);
        }
        ArrayType t = ArrayOptionsHelper.arrayType((long[])shape);
        return LongShapeDescriptor.fromShape((long[])Shape.shape((long[])shape), (long[])Shape.stride((long[])shape), (long)Shape.elementWiseStride((long[])shape), (char)Shape.order((long[])shape), (DataType)ArrayOptionsHelper.dataType((long[])shape), (t == ArrayType.EMPTY ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public List<LongShapeDescriptor> calculateOutputShape(@NonNull CustomOp op) {
        Nd4jCpu.ShapeList ptrptr;
        void var18_28;
        double[] tArgs1;
        boolean[] bArgs1;
        long[] iArgs1;
        if (op == null) {
            throw new NullPointerException("op is marked @NonNull but is null");
        }
        String lc = op.opName().toLowerCase();
        long hash = op.opHash();
        ArrayList<LongShapeDescriptor> result = new ArrayList<LongShapeDescriptor>();
        if (op.numInputArguments() < 1 && op.getDescriptor().getNumInputs() != -2) {
            if (log.isTraceEnabled()) {
                log.trace("Could not calculate output shape for op {}: number of input args was 0", (Object)op.getClass().getName());
            }
            return Collections.emptyList();
        }
        PointerPointer inputBuffers = new PointerPointer((long)op.numInputArguments());
        PointerPointer inputShapes = new PointerPointer((long)op.numInputArguments());
        INDArray[] inputArgs = op.inputArguments();
        int cnt = 0;
        for (INDArray in : inputArgs) {
            if (!in.isEmpty()) {
                inputBuffers.put((long)cnt, in.data().addressPointer());
            }
            inputShapes.put((long)cnt++, in.shapeInfoDataBuffer().addressPointer());
        }
        LongPointer iArgs = op.numIArguments() > 0 ? new LongPointer((long)op.numIArguments()) : null;
        cnt = 0;
        for (long i : iArgs1 = op.iArgs()) {
            iArgs.put((long)cnt++, i);
        }
        DoublePointer tArgs = op.numTArguments() > 0 ? new DoublePointer((long)op.numTArguments()) : null;
        BooleanPointer bArgs = op.numBArguments() > 0 ? new BooleanPointer((long)op.numBArguments()) : null;
        cnt = 0;
        for (boolean bl : bArgs1 = op.bArgs()) {
            bArgs.put((long)cnt++, bl);
        }
        cnt = 0;
        double[] dArray = tArgs1 = op.tArgs();
        int n = dArray.length;
        boolean bl = false;
        while (var18_28 < n) {
            double t = dArray[var18_28];
            tArgs.put((long)cnt++, t);
            ++var18_28;
        }
        try {
            ptrptr = (Nd4jCpu.ShapeList)this.loop.calculateOutputShapes(null, hash, inputBuffers, inputShapes, op.numInputArguments(), tArgs, op.numTArguments(), iArgs, op.numIArguments(), bArgs, op.numBArguments());
        }
        catch (Throwable t) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Inputs: [(");
            for (int i = 0; i < inputArgs.length; ++i) {
                if (i > 0) {
                    stringBuilder.append("), (");
                }
                stringBuilder.append(Shape.shapeToStringShort((INDArray)inputArgs[i]));
            }
            stringBuilder.append(")]");
            log.error("Failed to calculate output shapes for op " + op.opName() + ". Attempted to execute with " + String.valueOf(op.numInputArguments()) + " inputs, " + String.valueOf(op.numOutputArguments()) + " outputs, " + String.valueOf(op.numTArguments()) + " targs and " + String.valueOf(op.numIArguments()) + " iargs. " + stringBuilder.toString() + " - Please see above message (printed out from c++) for a possible cause of error.");
            throw t;
        }
        if (ptrptr == null) {
            throw new RuntimeException();
        }
        for (int e = 0; e < ptrptr.size(); ++e) {
            result.add(this.getShapeFromPointer(new PagedPointer((Pointer)ptrptr.at(e)).asLongPointer()));
        }
        this.loop.deleteShapeList((Pointer)ptrptr);
        if (log.isTraceEnabled()) {
            void var18_31;
            Object[] arr = new String[result.size()];
            boolean bl2 = false;
            while (var18_31 < result.size()) {
                arr[var18_31] = result.get((int)var18_31).toString();
                ++var18_31;
            }
            log.trace("Calculated output shapes for op {} - {}", (Object)op.getClass().getName(), (Object)Arrays.toString(arr));
        }
        return result;
    }

    public void enableDebugMode(boolean reallyEnable) {
        this.debug.set(reallyEnable);
        this.loop.enableDebugMode(reallyEnable);
    }

    public void enableVerboseMode(boolean reallyEnable) {
        this.verbose.set(reallyEnable);
        this.loop.enableVerboseMode(reallyEnable);
    }

    public void registerGraph(long id, Pointer graph) {
        this.loop.registerGraph(null, id, graph);
    }

    public Map<String, INDArray> executeGraph(long id, @NonNull Map<String, INDArray> map, @NonNull Map<String, Integer> reverseMap) {
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        if (reverseMap == null) {
            throw new NullPointerException("reverseMap is marked @NonNull but is null");
        }
        PointerPointer ptrBuffers = new PointerPointer((long)map.size());
        PointerPointer ptrShapes = new PointerPointer((long)map.size());
        IntPointer ptrIndices = new IntPointer((long)map.size());
        int cnt = 0;
        ArrayList<String> keySet = new ArrayList<String>(map.keySet());
        for (String key : keySet) {
            INDArray array = map.get(key);
            ptrBuffers.put((long)cnt, array.data().addressPointer());
            ptrShapes.put((long)cnt, array.shapeInfoDataBuffer().addressPointer());
            ptrIndices.put((long)cnt, reverseMap.get(key).intValue());
            ++cnt;
        }
        LinkedHashMap<String, INDArray> newMap = new LinkedHashMap<String, INDArray>();
        Nd4jCpu.VariablesSet result = (Nd4jCpu.VariablesSet)this.loop.executeStoredGraph(null, id, ptrBuffers, ptrShapes, ptrIndices, map.size());
        OpStatus status = OpStatus.byNumber((int)result.status());
        if (status != OpStatus.ND4J_STATUS_OK) {
            throw new ND4JIllegalStateException("Op execution failed: " + status);
        }
        for (int e = 0; e < result.size(); ++e) {
            Nd4jCpu.Variable var = result.at(e);
            int nodeId = var.id();
            int index = var.index();
            LongPointer shapeInfo = var.getNDArray().shapeInfo();
            Pointer buffer = var.getNDArray().buffer();
            int rank2 = (int)shapeInfo.get(0L);
            long[] jshape = new long[rank2 * 2 + 4];
            for (int i = 0; i < jshape.length; ++i) {
                jshape[i] = shapeInfo.get((long)i);
            }
            long[] shapeOf = Shape.shapeOf((long[])jshape);
            long[] stridesOf = Shape.stridesOf((long[])jshape);
            char order2 = Shape.order((long[])jshape);
            INDArray array = Nd4j.create((long[])shapeOf, (long[])stridesOf, (long)0L, (char)order2);
            long perfX = PerformanceTracker.getInstance().helperStartTransaction();
            Pointer.memcpy((Pointer)array.data().addressPointer(), (Pointer)buffer, (long)(Shape.lengthOf((long[])shapeOf) * (long)Nd4j.sizeOfDataType()));
            PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, Shape.lengthOf((long[])shapeOf) * (long)Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
            String nodeName = var.getName().getString();
            newMap.put(nodeName, array);
        }
        this.loop.deleteVariablesSet((Pointer)result);
        return newMap;
    }

    public void forgetGraph(long id) {
        this.loop.unregisterGraph(null, id);
    }

    public void setElementsThreshold(int threshold) {
        this.loop.setElementThreshold(threshold);
    }

    public void setTadThreshold(int threshold) {
        this.loop.setTADThreshold(threshold);
    }

    public String getString(Utf8Buffer buffer, long index) {
        long addr = ((LongIndexer)buffer.indexer()).get(index);
        PagedPointer ptr = new PagedPointer(addr);
        Nd4jCpu.utf8string str = new Nd4jCpu.utf8string((Pointer)ptr);
        return str._buffer().capacity((long)str._length()).getString();
    }

    public OpExecutioner.ExecutionerType type() {
        return OpExecutioner.ExecutionerType.NATIVE_CPU;
    }

    public boolean isExperimentalMode() {
        return this.experimentalMode.get();
    }

    public void scatterUpdate(ScatterUpdate.UpdateOp op, @NonNull INDArray array, @NonNull INDArray indices, @NonNull INDArray updates, @NonNull int[] axis) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        if (indices == null) {
            throw new NullPointerException("indices is marked @NonNull but is null");
        }
        if (updates == null) {
            throw new NullPointerException("updates is marked @NonNull but is null");
        }
        if (axis == null) {
            throw new NullPointerException("axis is marked @NonNull but is null");
        }
        Pair<DataBuffer, DataBuffer> tadX = this.tadManager.getTADOnlyShapeInfo(array, axis);
        Pair<DataBuffer, DataBuffer> tadY = this.tadManager.getTADOnlyShapeInfo(updates, axis);
        if (((DataBuffer)tadY.getSecond()).length() != indices.length()) {
            throw new IllegalStateException("Number of updates doesn't match number of indices. Bad dimensions used?");
        }
        this.loop.scatterUpdate(null, op.ordinal(), (int)indices.length(), array.data().addressPointer(), (LongPointer)((DataBuffer)tadX.getFirst()).addressPointer(), (LongPointer)((DataBuffer)tadX.getSecond()).addressPointer(), null, null, null, updates.data().addressPointer(), (LongPointer)((DataBuffer)tadY.getFirst()).addressPointer(), (LongPointer)((DataBuffer)tadY.getSecond()).addressPointer(), null, null, null, (IntPointer)indices.data().addressPointer(), null);
    }

    public OpContext buildContext() {
        return new CpuOpContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray[] exec(CustomOp op, @NonNull OpContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked @NonNull but is null");
        }
        boolean mklOverride = false;
        try {
            INDArray[] iNDArrayArray;
            if (Nd4jCpu.Environment.getInstance().isUseMKLDNN()) {
                String opName = op.opName();
                Boolean state = this.mklOverrides.get(op);
                if (state != null && state.booleanValue()) {
                    mklOverride = true;
                    Nd4jCpu.Environment.getInstance().setUseMKLDNN(true);
                }
            }
            this.loop.execCustomOp(null, op.opHash(), context.contextPointer());
            if (context.getOutputArrays().isEmpty()) {
                iNDArrayArray = new INDArray[]{};
                return iNDArrayArray;
            }
            iNDArrayArray = context.getOutputArrays().toArray(new INDArray[context.getOutputArrays().size()]);
            return iNDArrayArray;
        }
        finally {
            if (mklOverride) {
                Nd4jCpu.Environment.getInstance().setUseMKLDNN(true);
            }
        }
    }

    public INDArrayStatistics inspectArray(INDArray array) {
        Nd4jCpu.DebugInfo debugInfo = new Nd4jCpu.DebugInfo();
        this.loop.inspectArray(null, array.data().addressPointer(), (LongPointer)array.shapeInfoDataBuffer().addressPointer(), null, null, (Pointer)debugInfo);
        return INDArrayStatistics.builder().minValue(debugInfo._minValue()).maxValue(debugInfo._maxValue()).meanValue(debugInfo._meanValue()).stdDevValue(debugInfo._stdDevValue()).countInf(debugInfo._infCount()).countNaN(debugInfo._nanCount()).countNegative(debugInfo._negativeCount()).countPositive(debugInfo._positiveCount()).countZero(debugInfo._zeroCount()).build();
    }

    private static class AggregateMemoryBlock {
        private List<IntPointer> intArrays = new ArrayList<IntPointer>();
        private IntPointer indexingPointer;
        private Pointer realArgumentsPointer;
        private PointerPointer shapesPointer;
        private PointerPointer argumentsPointer;
        private PointerPointer arraysPointer;
        private final int opNum;

        private AggregateMemoryBlock(@NonNull Aggregate op) {
            if (op == null) {
                throw new NullPointerException("op is marked @NonNull but is null");
            }
            this.opNum = op.opNum();
            for (int i = 0; i < op.maxIntArrays(); ++i) {
                this.intArrays.add(new IntPointer((long)op.maxIntArraySize()));
            }
            this.indexingPointer = new IntPointer((long)op.maxIndexArguments());
            this.realArgumentsPointer = Nd4j.dataType() == DataType.DOUBLE ? new DoublePointer((long)op.maxRealArguments()) : new FloatPointer((long)op.maxRealArguments());
            this.shapesPointer = new PointerPointer((long)op.maxShapes());
            this.argumentsPointer = new PointerPointer((long)op.maxArguments());
            this.arraysPointer = new PointerPointer((long)op.maxIntArrays());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregateMemoryBlock that = (AggregateMemoryBlock)o;
            return this.opNum == that.opNum;
        }

        public int hashCode() {
            return this.opNum;
        }

        public List<IntPointer> getIntArrays() {
            return this.intArrays;
        }

        public IntPointer getIndexingPointer() {
            return this.indexingPointer;
        }

        public Pointer getRealArgumentsPointer() {
            return this.realArgumentsPointer;
        }

        public PointerPointer getShapesPointer() {
            return this.shapesPointer;
        }

        public PointerPointer getArgumentsPointer() {
            return this.argumentsPointer;
        }

        public PointerPointer getArraysPointer() {
            return this.arraysPointer;
        }

        public int getOpNum() {
            return this.opNum;
        }

        public void setIntArrays(List<IntPointer> intArrays) {
            this.intArrays = intArrays;
        }

        public void setIndexingPointer(IntPointer indexingPointer) {
            this.indexingPointer = indexingPointer;
        }

        public void setRealArgumentsPointer(Pointer realArgumentsPointer) {
            this.realArgumentsPointer = realArgumentsPointer;
        }

        public void setShapesPointer(PointerPointer shapesPointer) {
            this.shapesPointer = shapesPointer;
        }

        public void setArgumentsPointer(PointerPointer argumentsPointer) {
            this.argumentsPointer = argumentsPointer;
        }

        public void setArraysPointer(PointerPointer arraysPointer) {
            this.arraysPointer = arraysPointer;
        }

        public String toString() {
            return "NativeOpExecutioner.AggregateMemoryBlock(intArrays=" + this.getIntArrays() + ", indexingPointer=" + this.getIndexingPointer() + ", realArgumentsPointer=" + this.getRealArgumentsPointer() + ", shapesPointer=" + this.getShapesPointer() + ", argumentsPointer=" + this.getArgumentsPointer() + ", arraysPointer=" + this.getArraysPointer() + ", opNum=" + this.getOpNum() + ")";
        }
    }
}

