/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.ops;

import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOpContext;
import org.nd4j.linalg.api.ops.ExecutionMode;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.cpu.nativecpu.buffer.BaseCpuDataBuffer;
import org.nd4j.linalg.cpu.nativecpu.ops.CpuOpContextDeallocator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueContext;
import org.nd4j.nativeblas.OpaqueRandomGenerator;

public class CpuOpContext
extends BaseOpContext
implements OpContext,
Deallocatable {
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private OpaqueContext context = this.nativeOps.createGraphContext(1);
    private final transient long id = Nd4j.getDeallocatorService().nextValue();

    public CpuOpContext() {
        Nd4j.getDeallocatorService().pickObject((Deallocatable)this);
    }

    public void close() {
    }

    public void setIArguments(long ... arguments) {
        if (arguments.length > 0) {
            super.setIArguments(arguments);
            this.nativeOps.setGraphContextIArguments(this.context, new LongPointer(arguments), arguments.length);
        }
    }

    public void setBArguments(boolean ... arguments) {
        if (arguments.length > 0) {
            super.setBArguments(arguments);
            this.nativeOps.setGraphContextBArguments(this.context, new BooleanPointer(arguments), arguments.length);
        }
    }

    public void setTArguments(double ... arguments) {
        if (arguments.length > 0) {
            super.setTArguments(arguments);
            this.nativeOps.setGraphContextTArguments(this.context, new DoublePointer(arguments), arguments.length);
        }
    }

    public void setDArguments(DataType ... arguments) {
        if (arguments.length > 0) {
            super.setDArguments(arguments);
            int[] args = new int[arguments.length];
            for (int e = 0; e < arguments.length; ++e) {
                args[e] = arguments[e].toInt();
            }
            this.nativeOps.setGraphContextDArguments(this.context, new IntPointer(args), arguments.length);
        }
    }

    public void setRngStates(long rootState, long nodeState) {
        this.nativeOps.setRandomGeneratorStates(this.nativeOps.getGraphContextRandomGenerator(this.context), rootState, nodeState);
    }

    public Pair<Long, Long> getRngStates() {
        OpaqueRandomGenerator g = this.nativeOps.getGraphContextRandomGenerator(this.context);
        return Pair.makePair((Object)this.nativeOps.getRandomGeneratorRootState(g), (Object)this.nativeOps.getRandomGeneratorNodeState(g));
    }

    public void setInputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.nativeOps.setGraphContextInputBuffer(this.context, index, array.isEmpty() ? null : ((BaseCpuDataBuffer)array.data()).getOpaqueDataBuffer(), array.shapeInfoDataBuffer().addressPointer(), null);
        super.setInputArray(index, array);
    }

    public void setOutputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.nativeOps.setGraphContextOutputBuffer(this.context, index, array.isEmpty() ? null : ((BaseCpuDataBuffer)array.data()).getOpaqueDataBuffer(), array.shapeInfoDataBuffer().addressPointer(), null);
        super.setOutputArray(index, array);
    }

    public Pointer contextPointer() {
        return this.context;
    }

    public void markInplace(boolean reallyInplace) {
        this.nativeOps.markGraphContextInplace(this.context, reallyInplace);
    }

    public void allowHelpers(boolean reallyAllow) {
        this.nativeOps.ctxAllowHelpers(this.context, reallyAllow);
    }

    public void shapeFunctionOverride(boolean reallyOverride) {
        this.nativeOps.ctxShapeFunctionOverride(this.context, reallyOverride);
    }

    public void setExecutionMode(@NonNull ExecutionMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        super.setExecutionMode(mode);
        this.nativeOps.ctxSetExecutionMode(this.context, mode.ordinal());
    }

    public void purge() {
        super.purge();
        this.nativeOps.ctxPurge(this.context);
    }

    public String getUniqueId() {
        return new String("CTX_" + this.id);
    }

    public Deallocator deallocator() {
        return new CpuOpContextDeallocator(this);
    }

    public int targetDevice() {
        return 0;
    }
}

