/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.chunks.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.nd4j.common.primitives.AtomicBoolean;
import org.nd4j.common.util.ND4JFileUtils;
import org.nd4j.parameterserver.distributed.v2.chunks.ChunksTracker;
import org.nd4j.parameterserver.distributed.v2.chunks.VoidChunk;
import org.nd4j.parameterserver.distributed.v2.messages.VoidMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChunksTracker<T extends VoidMessage>
implements ChunksTracker<T> {
    private static final Logger log = LoggerFactory.getLogger(FileChunksTracker.class);
    private final String originId;
    private final int numChunks;
    private Map<Integer, AtomicBoolean> map = new ConcurrentHashMap<Integer, AtomicBoolean>();
    private File holder;
    private final long size;

    public FileChunksTracker(VoidChunk chunk) {
        this.originId = chunk.getOriginalId();
        this.numChunks = chunk.getNumberOfChunks();
        this.size = chunk.getTotalSize();
        try {
            this.holder = ND4JFileUtils.createTempFile((String)"FileChunksTracker", (String)"Message");
            this.holder.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(this.holder);
                 BufferedOutputStream bos = new BufferedOutputStream(fos, 32768);){
                int e = 0;
                while ((long)e < this.size) {
                    bos.write(0);
                    ++e;
                }
            }
            for (int e = 0; e < this.numChunks; ++e) {
                this.map.put(e, new AtomicBoolean(false));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean append(@NonNull VoidChunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        AtomicBoolean b = this.map.get(chunk.getChunkId());
        if (b.get()) {
            return this.isComplete();
        }
        try (RandomAccessFile f = new RandomAccessFile(this.holder, "rw");){
            f.seek(chunk.getChunkId() * chunk.getSplitSize());
            f.write(chunk.getPayload());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        b.set(true);
        return this.isComplete();
    }

    @Override
    public boolean isComplete() {
        for (AtomicBoolean b : this.map.values()) {
            if (b.get()) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public T getMessage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void release() {
        try {
            this.holder.delete();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOriginId() {
        return this.originId;
    }
}

